/*
 * Decompiled with CFR 0.152.
 */
package com.pixelduke.window;

import com.pixelduke.window.ThemeWindowManager;
import com.pixelduke.window.WindowUtils;
import com.sun.jna.PointerType;
import com.sun.jna.platform.win32.WinDef;
import impl.com.pixelduke.window.win32.windows11.DWM;
import impl.com.pixelduke.window.win32.windows11.DWMA_WINDOW_ATTRIBUTE;
import impl.com.pixelduke.window.win32.windows11.DWM_CORNER_PREFERENCE;
import impl.com.pixelduke.window.win32.windows11.DWM_SYSTEMBACKDROP_TYPE;
import impl.com.pixelduke.window.win32.windows11.DwmSupport;
import javafx.scene.paint.Color;
import javafx.stage.Window;

public class Win11ThemeWindowManager
implements ThemeWindowManager {
    @Override
    public void setDarkModeForWindowFrame(Window window, boolean darkMode) {
        DWM.setWindowAttribute(WindowUtils.getNativeHandleOfStage(window), DWMA_WINDOW_ATTRIBUTE.DWMWA_USE_IMMERSIVE_DARK_MODE.getValue(), darkMode);
    }

    public void setWindowBorderColor(Window window, Color color) {
        DWM.setWindowAttribute(WindowUtils.getNativeHandleOfStage(window), DWMA_WINDOW_ATTRIBUTE.DWMWA_BORDER_COLOR.getValue(), this.toRGBInt(color));
    }

    public void setWindowFrameColor(Window window, Color color) {
        DWM.setWindowAttribute(WindowUtils.getNativeHandleOfStage(window), DWMA_WINDOW_ATTRIBUTE.DWMWA_CAPTION_COLOR.getValue(), this.toRGBInt(color));
    }

    public void setWindowTextColor(Window window, Color color) {
        DWM.setWindowAttribute(WindowUtils.getNativeHandleOfStage(window), DWMA_WINDOW_ATTRIBUTE.DWMWA_TEXT_COLOR.getValue(), this.toRGBInt(color));
    }

    public void setWindowBackdrop(Window window, Backdrop backdrop) {
        switch (backdrop) {
            case NONE: {
                DwmSupport.INSTANCE.DwmSetWindowAttribute(WindowUtils.getNativeHandleOfStage(window), DWMA_WINDOW_ATTRIBUTE.DWMWA_SYSTEMBACKDROP_TYPE.getValue(), (PointerType)new WinDef.DWORDByReference(new WinDef.DWORD((long)DWM_SYSTEMBACKDROP_TYPE.NONE.getValue())), 4);
                break;
            }
            case MICA: {
                DwmSupport.INSTANCE.DwmSetWindowAttribute(WindowUtils.getNativeHandleOfStage(window), DWMA_WINDOW_ATTRIBUTE.DWMWA_SYSTEMBACKDROP_TYPE.getValue(), (PointerType)new WinDef.DWORDByReference(new WinDef.DWORD((long)DWM_SYSTEMBACKDROP_TYPE.MICA.getValue())), 4);
                break;
            }
            case MICA_ALT: {
                DwmSupport.INSTANCE.DwmSetWindowAttribute(WindowUtils.getNativeHandleOfStage(window), DWMA_WINDOW_ATTRIBUTE.DWMWA_SYSTEMBACKDROP_TYPE.getValue(), (PointerType)new WinDef.DWORDByReference(new WinDef.DWORD((long)DWM_SYSTEMBACKDROP_TYPE.MICA_ALT.getValue())), 4);
                break;
            }
            case ACRYLIC: {
                DwmSupport.INSTANCE.DwmSetWindowAttribute(WindowUtils.getNativeHandleOfStage(window), DWMA_WINDOW_ATTRIBUTE.DWMWA_SYSTEMBACKDROP_TYPE.getValue(), (PointerType)new WinDef.DWORDByReference(new WinDef.DWORD((long)DWM_SYSTEMBACKDROP_TYPE.ACRYLIC.getValue())), 4);
            }
        }
    }

    public void setWindowCornerPreference(Window window, CornerPreference cornerPreference) {
        switch (cornerPreference) {
            case RECTANGULAR: {
                DwmSupport.INSTANCE.DwmSetWindowAttribute(WindowUtils.getNativeHandleOfStage(window), DWMA_WINDOW_ATTRIBUTE.DWMWA_WINDOW_CORNER_PREFERENCE.getValue(), (PointerType)new WinDef.DWORDByReference(new WinDef.DWORD((long)DWM_CORNER_PREFERENCE.RECTANGULAR.getValue())), 4);
                break;
            }
            case ROUND: {
                DwmSupport.INSTANCE.DwmSetWindowAttribute(WindowUtils.getNativeHandleOfStage(window), DWMA_WINDOW_ATTRIBUTE.DWMWA_WINDOW_CORNER_PREFERENCE.getValue(), (PointerType)new WinDef.DWORDByReference(new WinDef.DWORD((long)DWM_CORNER_PREFERENCE.ROUND.getValue())), 4);
                break;
            }
            case ROUND_SMALL: {
                DwmSupport.INSTANCE.DwmSetWindowAttribute(WindowUtils.getNativeHandleOfStage(window), DWMA_WINDOW_ATTRIBUTE.DWMWA_WINDOW_CORNER_PREFERENCE.getValue(), (PointerType)new WinDef.DWORDByReference(new WinDef.DWORD((long)DWM_CORNER_PREFERENCE.ROUND_SMALL.getValue())), 4);
            }
        }
    }

    private int toRGBInt(Color color) {
        return this.doubleTo8Bit(color.getBlue()) << 16 | this.doubleTo8Bit(color.getGreen()) << 8 | this.doubleTo8Bit(color.getRed());
    }

    private int doubleTo8Bit(double number) {
        return (int)Math.min(255.0, Math.max(number * 255.0, 0.0));
    }

    public static enum Backdrop {
        NONE,
        MICA,
        MICA_ALT,
        ACRYLIC;

    }

    public static enum CornerPreference {
        RECTANGULAR,
        ROUND,
        ROUND_SMALL;

    }
}

