/*
 * Decompiled with CFR 0.152.
 */
package com.pixelduke.window;

import com.pixelduke.window.LinuxThemeWindowManager;
import com.pixelduke.window.MacThemeWindowManager;
import com.pixelduke.window.ThemeWindowManager;
import com.pixelduke.window.Win10ThemeWindowManager;
import com.pixelduke.window.Win11ThemeWindowManager;
import com.sun.jna.Platform;
import javafx.stage.Window;

public abstract class ThemeWindowManagerFactory {
    public static ThemeWindowManager create() {
        String osName = System.getProperty("os.name");
        if (Platform.isWindows()) {
            if (osName.equals("Windows 10")) {
                return new Win10ThemeWindowManager();
            }
            return new Win11ThemeWindowManager();
        }
        if (Platform.isMac()) {
            return new MacThemeWindowManager();
        }
        if (Platform.isLinux()) {
            return new LinuxThemeWindowManager();
        }
        return new ThemeWindowManager(){

            @Override
            public void setDarkModeForWindowFrame(Window window, boolean darkMode) {
                System.out.println("Warning: Unsupported Window Operating System");
            }
        };
    }
}

