/*
 * Decompiled with CFR 0.152.
 */
package com.pixelduke.window;

import com.pixelduke.window.FoundationLibrary;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

interface FXThemesLibrary
extends Library {
    public static final NativeLong NULL = new NativeLong(0L);
    public static final FXThemesLibrary INSTANCE = (FXThemesLibrary)Native.load((String)"FXThemes", FXThemesLibrary.class, Map.of("string-encoding", StandardCharsets.UTF_8.name()));
    public static final NativeLong stringCls = FoundationLibrary.INSTANCE.objc_getClass("NSString");
    public static final Pointer stringSel = FoundationLibrary.INSTANCE.sel_registerName("string");
    public static final Pointer allocSel = FoundationLibrary.INSTANCE.sel_registerName("alloc");
    public static final Pointer initWithBytesLengthEncodingSel = FoundationLibrary.INSTANCE.sel_registerName("initWithBytes:length:encoding:");
    public static final long NSUTF16LittleEndianStringEncoding = -1811939072L;

    public void setAppearanceByName(NativeLong var1, NativeLong var2);

    public static String toNativeString(NativeLong nativeLong) {
        if (NULL.equals((Object)nativeLong)) {
            return null;
        }
        CoreFoundation.CFStringRef cfString = new CoreFoundation.CFStringRef(new Pointer(nativeLong.longValue()));
        try {
            String string = CoreFoundation.INSTANCE.CFStringGetLength(cfString).intValue() > 0 ? cfString.stringValue() : "";
            return string;
        }
        finally {
            cfString.release();
        }
    }

    public static NativeLong fromJavaString(String s) {
        if (s.isEmpty()) {
            return FoundationLibrary.INSTANCE.objc_msgSend(stringCls, stringSel);
        }
        byte[] utf16Bytes = s.getBytes(Charset.forName("UTF-16LE"));
        return FoundationLibrary.INSTANCE.objc_msgSend(FoundationLibrary.INSTANCE.objc_msgSend(stringCls, allocSel), initWithBytesLengthEncodingSel, utf16Bytes, utf16Bytes.length, -1811939072L);
    }
}

