/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.views;

import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;

public final class FXMLViewFactory<T, K> {
    private static final Logger LOG = Logger.getLogger(FXMLViewFactory.class.getName());
    @Inject
    private LanguageResource languageResource;
    private T controller;
    private K component;
    private final String viewPath;

    public FXMLViewFactory(String viewPath) {
        this.viewPath = viewPath;
        Container.inject(this);
    }

    public FXMLViewFactory(String viewPath, T controller) {
        this.viewPath = viewPath;
        this.controller = controller;
        Container.inject(this);
    }

    public FXMLViewFactory<T, K> create() {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(this.viewPath));
            loader.setResources(this.languageResource.getResourceBundle());
            if (this.controller != null) {
                loader.setController(this.controller);
            }
            this.component = loader.load();
            this.controller = loader.getController();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return this;
    }

    public T getController() {
        return this.controller;
    }

    public K getComponent() {
        return this.component;
    }
}

