/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.ui.style;

import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import de.mallongigi.ui.style.CssClass;
import java.net.URL;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.DialogPane;
import javafx.stage.Stage;

@Singleton
public final class Styles {
    private static final String STLYE_PATH = "/de/mallongigi/css/style.css";
    @Inject
    private IconFactory iconFactory;

    private Styles() {
    }

    public void setStyle(Node component, CssClass cssClass) {
        ArrayList<String> excludes = new ArrayList<String>();
        ObservableList list = component.getStyleClass();
        for (String s : list) {
            if (!s.startsWith("mallongigi_")) continue;
            excludes.add(s);
        }
        component.getStyleClass().removeAll(excludes);
        component.getStyleClass().add((Object)cssClass.cssClass());
    }

    public void setStyle(Scene scene) {
        URL url = new Styles().getClass().getResource(STLYE_PATH);
        scene.getStylesheets().add((Object)url.toExternalForm());
    }

    public void setStyle(DialogPane dialogPane) {
        URL url = new Styles().getClass().getResource(STLYE_PATH);
        dialogPane.getStylesheets().add((Object)url.toExternalForm());
    }

    public void setWindowIcon(DialogPane dialogPane, DefaultIcons icon) {
        ((Stage)dialogPane.getScene().getWindow()).getIcons().add((Object)this.iconFactory.createIcon(icon, 16));
    }
}

