/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.ui.elements;

import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconColors;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.style.Styles;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;

public final class UIToggleButton
extends ToggleButton {
    @Inject
    private IconFactory iconFactory;
    @Inject
    private Styles styles;
    @Inject
    private LanguageResource languageResource;

    public UIToggleButton(LanguageKeys label, DefaultIcons image) {
        this(label, image, 32, label.name());
    }

    private UIToggleButton(LanguageKeys label, DefaultIcons image, int imageSize, String id) {
        Container.inject((Object)this);
        String text = this.languageResource.messageForKey(label);
        this.setId(id);
        this.setText(text);
        Node imageNode = this.iconFactory.create(image, imageSize);
        this.setGraphic(imageNode);
        this.addImageListener(imageNode, imageSize);
    }

    private void addImageListener(final Node image, int size) {
        this.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    UIToggleButton.this.styles.setStyle(image, IconColors.Focus);
                } else {
                    UIToggleButton.this.styles.setStyle(image, IconColors.Default);
                }
            }
        });
    }
}

