/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.ui.elements;

import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.PopupContainer;
import de.mallongigi.ui.elements.UIButton;
import de.mallongigi.ui.style.BasicCssClasses;
import de.mallongigi.ui.style.Styles;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Popup;
import javafx.stage.Stage;
import javafx.stage.Window;

public final class UIPopOver
extends Popup {
    @Inject(safety=false)
    private Stage primaryStage;
    @Inject
    private PopupContainer popupContainer;
    @Inject
    private Styles styles;
    @Inject
    private LanguageResource languageResource;
    private final String text;
    private final String title;
    private final VBox root = new VBox(10.0);
    private final double popupWidth;

    public UIPopOver(LanguageKeys title, String text, double popupwidth) {
        Container.inject((Object)this);
        this.title = this.languageResource.messageForKey(title);
        this.text = text;
        this.popupWidth = popupwidth;
        this.create();
    }

    private void create() {
        BorderPane header = new BorderPane();
        Label headerLabel = new Label(this.title);
        this.styles.setStyle((Node)headerLabel, BasicCssClasses.title);
        header.setCenter((Node)headerLabel);
        UIButton button = new UIButton(DefaultIcons.close);
        button.setOnAction(e -> this.hide());
        header.setRight((Node)button);
        HBox content = new HBox(20.0);
        Label contentLabel = new Label(this.text);
        contentLabel.setWrapText(true);
        content.getChildren().add((Object)contentLabel);
        ScrollPane scrollPane = new ScrollPane((Node)content);
        scrollPane.setFitToWidth(true);
        scrollPane.setMinHeight(150.0);
        this.root.getChildren().addAll((Object[])new Node[]{header, scrollPane});
        this.getContent().addAll((Object[])new Node[]{this.root});
    }

    public void show(MouseEvent event) {
        double xPosition = event.getScreenX() - this.popupWidth;
        if (xPosition < 0.0) {
            xPosition = 0.0;
        }
        this.root.setMaxWidth(this.popupWidth);
        this.setY(event.getScreenY());
        this.setX(xPosition);
        this.popupContainer.set(this);
        this.show((Window)this.primaryStage);
    }
}

