/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.ui.elements;

import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconColors;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.style.Styles;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;

public class UIButton
extends Button {
    @Inject
    private LanguageResource languageResource;
    @Inject
    private IconFactory iconFactory;
    @Inject
    private Styles styles;

    public UIButton(LanguageKeys label, DefaultIcons image, int imageSize, String id) {
        Container.inject((Object)this);
        String text = this.languageResource.messageForKey(label);
        this.setId(id);
        this.setText(text);
        this.initImage(image, imageSize);
    }

    public UIButton(LanguageKeys label, DefaultIcons image, int imageSize) {
        this(label, image, imageSize, label.name());
    }

    public UIButton(LanguageKeys label, DefaultIcons image) {
        this(label, image, 32);
    }

    public UIButton(LanguageKeys label) {
        Container.inject((Object)this);
        this.setId(label.name());
        this.setText(this.languageResource.messageForKey(label));
    }

    public UIButton(LanguageKeys label, DefaultIcons image, String id) {
        this(label, image, 32, id);
    }

    public UIButton(DefaultIcons image) {
        Container.inject((Object)this);
        this.initImage(image, 32);
    }

    private void initImage(DefaultIcons image, int imageSize) {
        switch (image.getIconFormat()) {
            case PIXEL: {
                this.setGraphic(this.iconFactory.create(image, imageSize));
                break;
            }
            case SVG_PATH: {
                Node imageComponent = this.iconFactory.create(image, imageSize);
                this.setGraphic(imageComponent);
                new ButtonHandler(this, imageComponent);
            }
        }
    }

    class ButtonHandler {
        private Button button;
        private Node svgImage;

        private ButtonHandler(Button button, Node svgImage) {
            this.button = button;
            this.svgImage = svgImage;
            button.focusedProperty().addListener(f -> this.onFocus());
            button.setOnMouseEntered(e -> this.onEnter((MouseEvent)e));
            button.setOnMouseExited(e -> this.onExit((MouseEvent)e));
        }

        private void onEnter(MouseEvent e) {
            this.showFocusImage();
        }

        private void onExit(MouseEvent e) {
            this.showDefaultImage();
        }

        private void onFocus() {
            if (this.button.isFocused()) {
                this.showFocusImage();
            } else {
                this.showDefaultImage();
            }
        }

        private void showFocusImage() {
            if (this.button.isDisable()) {
                return;
            }
            UIButton.this.styles.setStyle(this.svgImage, IconColors.Focus);
        }

        private void showDefaultImage() {
            UIButton.this.styles.setStyle(this.svgImage, IconColors.Default);
        }
    }
}

