/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.ui.elements;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.resource.language.LanguageKeys;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public final class HTMLView
extends BorderPane {
    private static final Logger LOG = Logger.getLogger(HTMLView.class.getName());
    private String template;
    private WebView browser;
    private String cssStyle;

    public HTMLView(String source) {
        this.init(source);
    }

    public void setContent(String ... values) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.cssStyle);
        for (String v : values) {
            params.add(v);
        }
        String content = MessageFormat.format(this.template, params.toArray());
        this.browser.getEngine().loadContent(content);
    }

    public void setTemplate(String source) {
        try {
            this.createTemplate(source);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void init(String source) {
        try {
            this.createTemplate(source);
            this.createCSStyle();
            this.browser = new WebView();
            this.browser.getEngine().getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue == Worker.State.SUCCEEDED) {
                    EventListener listener = new EventListener(this){

                        @Override
                        public void handleEvent(Event ev) {
                            String url = ((Element)((Object)ev.getTarget())).getAttribute("extern_link");
                            if (url == null || url.length() == 0) {
                                return;
                            }
                            Desktop desktop = Desktop.getDesktop();
                            try {
                                desktop.browse(new URI(url));
                            }
                            catch (Exception e1) {
                                new ErrorDialog().show(LanguageKeys.errorMessageExecuteBrowser, e1, url);
                            }
                        }
                    };
                    Document doc = this.browser.getEngine().getDocument();
                    NodeList lista = doc.getElementsByTagName("a");
                    for (int i = 0; i < lista.getLength(); ++i) {
                        Element e = (Element)lista.item(i);
                        ((EventTarget)((Object)e)).addEventListener("click", listener, false);
                        String link = e.getAttribute("href");
                        e.setAttribute("extern_link", link);
                        e.setAttribute("href", "#");
                    }
                }
            });
            this.setCenter((Node)this.browser);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void createCSStyle() throws IOException {
        StringBuffer buffer = new StringBuffer();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/de/mallongigi/html/style.css")));){
            String line;
            while ((line = in.readLine()) != null) {
                buffer.append(line).append("\n");
            }
        }
        this.cssStyle = "<style>" + buffer.toString() + "</style>";
    }

    private void createTemplate(String source) throws IOException {
        StringBuffer buffer = new StringBuffer();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(source)));){
            String line;
            while ((line = in.readLine()) != null) {
                buffer.append(line).append("\n");
            }
        }
        this.template = buffer.toString();
    }

    public void setTextByElementId(String id, String text) {
        Element element;
        Document doc = this.browser.getEngine().getDocument();
        if (doc != null && (element = doc.getElementById(id)) != null) {
            element.setTextContent(text);
        }
    }

    public void setAttributeByElementId(String id, String attribute, String value) {
        Element element;
        Document doc = this.browser.getEngine().getDocument();
        if (doc != null && (element = doc.getElementById(id)) != null) {
            element.setAttribute(attribute, value);
        }
    }

    public String getAttributeByElementId(String id, String attribute) {
        Element element;
        Document doc = this.browser.getEngine().getDocument();
        if (doc != null && (element = doc.getElementById(id)) != null) {
            return element.getAttribute(attribute);
        }
        return null;
    }
}

