/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.toolbar.usbstick;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import de.mallongigi.toolbar.ApplicationToolbarModel;
import de.mallongigi.toolbar.usbstick.USBComponentModel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.StringProperty;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import javafx.util.Duration;

@Singleton
public final class UsbStickAvailableService
extends ScheduledService<UsbStickAvailableState> {
    @Inject
    private PodcastChannelContainer podcastChannelContainer;
    @Inject
    private ApplicationSettings settings;
    @Inject
    private ApplicationToolbarModel applicationToolbarModel;

    UsbStickAvailableService() {
        this.setPeriod(Duration.seconds((double)10.0));
        this.setRestartOnFailure(true);
    }

    protected Task<UsbStickAvailableState> createTask() {
        return new Task<UsbStickAvailableState>(){

            protected UsbStickAvailableState call() {
                return UsbStickAvailableService.this.readUSBPathInformation();
            }
        };
    }

    protected void succeeded() {
        this.updateApplikationBarModel((UsbStickAvailableState)this.getValue());
        super.succeeded();
    }

    protected void failed() {
        new ErrorDialog().show(LanguageKeys.errorRefreshAll, this.getException());
        super.failed();
    }

    public void updateNow() {
        this.updateApplikationBarModel(this.readUSBPathInformation());
    }

    public void updateApplikationBarModel(UsbStickAvailableState state) {
        for (StringProperty s : state.removePathList) {
            this.applicationToolbarModel.getUsbList().remove(s);
        }
        for (StringProperty s : state.availablePathList) {
            this.applicationToolbarModel.getUsbList().add(s);
        }
        for (PodcastChannelModel pcm : this.podcastChannelContainer.getPodcastChannels(PodcastNavigationViewType.Podcast)) {
            String channelPath = pcm.getUsbPath();
            if (channelPath == null || channelPath.isBlank()) {
                pcm.setUsbStickIsAvailable(state.globalPathIsAvailable);
                continue;
            }
            pcm.setUsbStickIsAvailable(false);
            for (StringProperty s : state.availablePathList) {
                if (!channelPath.equals(s.get())) continue;
                pcm.setUsbStickIsAvailable(true);
            }
        }
        this.applicationToolbarModel.refreshAll();
    }

    public UsbStickAvailableState readUSBPathInformation() {
        UsbStickAvailableState result = new UsbStickAvailableState(this);
        String path = this.settings.getUsbStickPathProperty().getValue();
        if (path != null && !path.isBlank()) {
            result.globalPathIsAvailable = new File(path).exists();
            if (result.globalPathIsAvailable) {
                result.availablePathList.add((StringProperty)this.settings.getUsbStickPathProperty());
            }
        }
        for (USBComponentModel u : this.applicationToolbarModel.getUsbList().getUSBComponents()) {
            if (u.pathProperty().get() == null || new File((String)u.pathProperty().get()).exists()) continue;
            result.removePathList.add(u.pathProperty());
        }
        for (PodcastChannelModel pcm : this.podcastChannelContainer.getPodcastChannels(PodcastNavigationViewType.Podcast)) {
            String channelPath = pcm.getUsbPath();
            if (channelPath == null || channelPath.isBlank() || !new File(channelPath).exists()) continue;
            result.availablePathList.add(pcm.usbPathProperty());
        }
        return result;
    }

    class UsbStickAvailableState {
        private boolean globalPathIsAvailable = false;
        private List<StringProperty> availablePathList = new ArrayList<StringProperty>();
        private List<StringProperty> removePathList = new ArrayList<StringProperty>();

        private UsbStickAvailableState(UsbStickAvailableService this$0) {
        }
    }
}

