/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.toolbar.usbstick;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.toolbar.usbstick.USBComponentModel;
import de.mallongigi.ui.style.Styles;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;

public final class USBStickResourceViewController {
    private final USBComponentModel model;
    @Inject
    private IconFactory iconFactory;
    @Inject
    private OSPlatform osPlatform;
    @Inject
    private Styles styles;
    @FXML
    private HBox usbStickInfoRoot;
    @FXML
    private Label fileSize;
    @FXML
    private Label completeDuration;
    @FXML
    private Label freeSpaces;
    @FXML
    private Label usbPath;
    @FXML
    private HBox refreshButton;
    @FXML
    private HBox openButton;

    public USBStickResourceViewController(USBComponentModel model) {
        Container.inject(this);
        this.model = model;
    }

    @FXML
    private void initialize() {
        this.usbPath.setText((String)this.model.pathProperty().get());
        this.fileSize.textProperty().bind((ObservableValue)this.model.fileSizeProperty());
        this.freeSpaces.textProperty().bind((ObservableValue)this.model.freeDiskSpaceProperty());
        this.completeDuration.textProperty().bind((ObservableValue)this.model.getCompleteDuration());
        this.model.addCopyModeListener((ChangeListener<? super Boolean>)((ChangeListener)(p, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.completeDuration.setStyle("-fx-text-fill : chocolate;");
                this.fileSize.setStyle("-fx-text-fill : chocolate;");
            } else {
                this.completeDuration.setStyle("");
                this.fileSize.setStyle("");
            }
        }));
        Node refresh = this.iconFactory.create(DefaultIcons.RefreshPodcastChannel, 16);
        Node open = this.iconFactory.create(DefaultIcons.OpenFolder, 16);
        this.refreshButton.getChildren().add((Object)refresh);
        this.openButton.getChildren().add((Object)open);
    }

    public void openFolder() {
        try {
            Path file = Paths.get((String)this.model.pathProperty().get(), new String[0]);
            this.osPlatform.open(file);
        }
        catch (IOException e) {
            new ErrorDialog().show(LanguageKeys.errorMessageOpenFolder, (Throwable)e);
        }
    }

    public void update() {
        this.model.refreshInSyncMode();
    }
}

