/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.toolbar.usbstick;

import de.mallongigi.ffmpeg.FFProbeMediaInfo;
import de.mallongigi.file.FileUtil;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.time.DateTimeConverter;
import de.mallongigi.toolbar.usbstick.USBComponentModel;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.time.LocalTime;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;

public final class USBStickDetailInformationService
extends Service<Result> {
    @Inject
    private DateTimeConverter durationFormat;
    @Inject
    private ApplicationSettings settings;
    private static final Logger LOG = Logger.getLogger(USBStickDetailInformationService.class.getName());
    private final USBComponentModel model;
    private final DecimalFormat gigabyteFormat = new DecimalFormat("###.### GB");
    private boolean syncAlways = false;

    USBStickDetailInformationService(USBComponentModel usbComponentModel) {
        Container.inject((Object)this);
        this.model = usbComponentModel;
        this.model.pathProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                USBStickDetailInformationService.this.model.refresh();
            }
        });
    }

    void setSyncAlwaysMode() {
        this.syncAlways = true;
    }

    protected Task<Result> createTask() {
        return new Task<Result>(){

            protected Result call() throws Exception {
                Path directory = Paths.get((String)USBStickDetailInformationService.this.model.pathProperty().get(), new String[0]);
                List<Path> fileList = Files.list(directory).toList();
                if (!USBStickDetailInformationService.this.syncAlways && (USBStickDetailInformationService.this.model.isCopyModus() || String.valueOf(fileList.size()).equals(USBStickDetailInformationService.this.model.fileSizeProperty().get()) && !((String)USBStickDetailInformationService.this.model.getCompleteDuration().get()).equals("?"))) {
                    return null;
                }
                String duration = "?";
                double freeDiskSpace = 0.0;
                try {
                    FileStore store = Files.getFileStore(directory);
                    freeDiskSpace = USBStickDetailInformationService.this.getGigabytes(store.getUsableSpace());
                    FFProbeMediaInfo mediaInfo = new FFProbeMediaInfo();
                    if (USBStickDetailInformationService.this.settings.isConverterAvailable()) {
                        LocalTime d = LocalTime.of(0, 0, 0);
                        for (Path f : fileList) {
                            String result;
                            if (!Files.isRegularFile(f, new LinkOption[0]) || FileUtil.getFileFormat(f.getFileName().toString()) == null || (result = mediaInfo.getDuration(f)) == null || result.equals("?")) continue;
                            LocalTime l = USBStickDetailInformationService.this.durationFormat.convertDurationTime(result);
                            d = d.plusSeconds(l.getSecond());
                            d = d.plusMinutes(l.getMinute());
                            d = d.plusHours(l.getHour());
                        }
                        duration = d.format(USBStickDetailInformationService.this.durationFormat.getDurationFormatter());
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, e.getMessage(), e);
                }
                return new Result(duration, USBStickDetailInformationService.this.gigabyteFormat.format(freeDiskSpace), fileList.size());
            }
        };
    }

    protected void succeeded() {
        Result r = (Result)this.getValue();
        if (r == null) {
            return;
        }
        this.model.setCompleteDuration(r.duration);
        this.model.setFileSize(r.fileSize);
        this.model.setFreeSpace(r.freeDiskSpace);
        this.syncAlways = false;
        super.succeeded();
    }

    private double getGigabytes(long bytes) {
        return bytes / 1024L / 1024L / 1024L;
    }

    protected record Result(String duration, String freeDiskSpace, int fileSize) {
    }
}

