/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.time;

import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import de.mallongigi.time.DateTimeConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Singleton
public final class PodloveTimeConverter {
    @Inject
    private DateTimeConverter dateTimeConverter;

    private PodloveTimeConverter() {
    }

    public Long convert(String startTime) {
        String time = startTime.trim();
        Long result = this.parseSeconds(time);
        if (result != null) {
            return result;
        }
        result = this.parseMinutes(time);
        if (result != null) {
            return result;
        }
        result = this.parseHours(time);
        if (result != null) {
            return result;
        }
        return null;
    }

    private Long parseHours(String time) {
        long result = 0L;
        Matcher matcher = Pattern.compile("^(\\d+):(\\d\\d?):(\\d\\d?)(?:\\.(\\d+))?$").matcher(time);
        if (matcher.find()) {
            result += (long)(Integer.parseInt(matcher.group(3), 10) * 1000);
            result += (long)(Integer.parseInt(matcher.group(2), 10) * 1000 * 60);
            return result += (long)(Integer.parseInt(matcher.group(1), 10) * 1000 * 60 * 60);
        }
        return null;
    }

    private Long parseMinutes(String time) {
        long result = 0L;
        Matcher matcher = Pattern.compile("^(\\d+):(\\d\\d?)(?:\\.(\\d+))?$").matcher(time);
        if (matcher.find()) {
            result += (long)(Integer.parseInt(matcher.group(2), 10) * 1000);
            return result += (long)(Integer.parseInt(matcher.group(1), 10) * 1000 * 60);
        }
        return null;
    }

    private Long parseSeconds(String time) {
        long result = 0L;
        Matcher matcher = Pattern.compile("^(\\d+)(?:\\.(\\d+))?$").matcher(time);
        if (matcher.find()) {
            return result += (long)(Integer.parseInt(matcher.group(1), 10) * 1000);
        }
        return null;
    }
}

