/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.start.preload;

import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.settings.CopySettings;
import de.mallongigi.settings.LoadSettings;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Container;
import de.mallongigi.start.preload.PreLoadTaskInterface;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;

public final class PreLoaderTaks
extends Task<ObservableList<String>>
implements PreLoadTaskInterface {
    private static final Logger LOG = Logger.getLogger(PreLoaderTaks.class.getName());

    protected ObservableList<String> call() throws Exception {
        ObservableList foundFriends = FXCollections.observableArrayList();
        try {
            Path lastSettingFile = new CopySettings().execute();
            ApplicationSettings settings = new LoadSettings(this).execute();
            settings.setLastSettingFile(lastSettingFile);
            Container.add(settings);
            new PodcastChannelContainer(settings.getChannels());
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return foundFriends;
    }

    @Override
    public void update(long current, long max) {
        this.updateProgress(current, max);
    }

    @Override
    public void update(String taskName) {
        String message = "Load Channel Datas : " + taskName;
        this.updateMessage(message);
    }
}

