/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.start;

import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.start.SettingsProcessCompleteHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;

public final class PreLoaderWindow {
    private static final Logger LOG = Logger.getLogger(PreLoaderWindow.class.getName());
    private ProgressBar loadProgress;
    private Label progressText;
    private Pane splashLayout;
    private static final int SPLASH_WIDTH = 649;
    private static final int SPLASH_HEIGHT = 200;

    PreLoaderWindow() {
    }

    void init() {
        try {
            ImageView splash = new ImageView(new Image(this.getClass().getResourceAsStream(DefaultIcons.preLoadImage.getLocation()), 649.0, 200.0, false, false));
            this.loadProgress = new ProgressBar();
            this.loadProgress.setPrefWidth(629.0);
            this.progressText = new Label("Init Mallongigi");
            Label versionLabel = new Label("Version : " + ApplicationSettings.getVersion());
            this.progressText.setTextFill((Paint)Color.web((String)"#ffffff"));
            versionLabel.setTextFill((Paint)Color.web((String)"#ffffff"));
            this.splashLayout = new VBox();
            this.splashLayout.getChildren().addAll((Object[])new Node[]{splash, versionLabel, this.loadProgress, this.progressText});
            this.progressText.setAlignment(Pos.CENTER);
            this.splashLayout.setStyle("-fx-padding: 5; -fx-background-color: #1E1F25; -fx-border-width:5; -fx-border-color: linear-gradient(to bottom, black, derive(black, 50%)); ");
            this.splashLayout.setEffect((Effect)new DropShadow());
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    void show(Stage initStage, Task<ObservableList<String>> task, SettingsProcessCompleteHandler completionHandler) {
        initStage.getIcons().add((Object)new Image(this.getClass().getResourceAsStream(DefaultIcons.Window.getLocation()), 32.0, 32.0, false, false));
        this.progressText.textProperty().bind((ObservableValue)task.messageProperty());
        this.loadProgress.progressProperty().bind((ObservableValue)task.progressProperty());
        task.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                this.loadProgress.progressProperty().unbind();
                this.loadProgress.setProgress(1.0);
                initStage.toFront();
                FadeTransition fadeSplash = new FadeTransition(Duration.seconds((double)1.2), (Node)this.splashLayout);
                fadeSplash.setFromValue(1.0);
                fadeSplash.setToValue(0.0);
                fadeSplash.setOnFinished(actionEvent -> initStage.hide());
                fadeSplash.play();
                completionHandler.complete();
            }
        });
        Scene splashScene = new Scene((Parent)this.splashLayout, (Paint)Color.TRANSPARENT);
        Rectangle2D bounds = Screen.getPrimary().getBounds();
        initStage.setScene(splashScene);
        initStage.setX(bounds.getMinX() + bounds.getWidth() / 2.0 - 324.0);
        initStage.setY(bounds.getMinY() + bounds.getHeight() / 2.0 - 100.0);
        initStage.initStyle(StageStyle.TRANSPARENT);
        initStage.show();
    }
}

