/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.start;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.errorhandling.ErrorContainer;
import de.mallongigi.file.FileUtil;
import de.mallongigi.file.chooser.SystemFileChooser;
import de.mallongigi.http.VersionCheck;
import de.mallongigi.images.ImageContainer;
import de.mallongigi.images.model.ImageModelFactory;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.platform.PlattformFactory;
import de.mallongigi.platform.WindowsPlatform;
import de.mallongigi.podcast.channel.ui.RefreshAutomaticServices;
import de.mallongigi.podcast.progress.ProgressPool;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.settings.SettingFile;
import de.mallongigi.settings.json.SaveSettings;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.InitialisationErrorListener;
import de.mallongigi.start.PreLoaderWindow;
import de.mallongigi.start.preload.PreLoaderTaks;
import de.mallongigi.toolbar.usbstick.UsbStickAvailableService;
import de.mallongigi.ui.style.Styles;
import de.mallongigi.views.ApplicationViews;
import java.awt.SplashScreen;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public final class Main
extends Application {
    private final long time = System.currentTimeMillis();
    private static final Logger LOG = Logger.getLogger(Main.class.getName());
    private Stage stage;
    private PreLoaderWindow preLoader;

    public void init() throws Exception {
        super.init();
        this.preLoader = new PreLoaderWindow();
        this.preLoader.init();
    }

    public void start(Stage primaryStage) throws Exception {
        LOG.info("---- Start Mallongigi ----");
        Container.reset(new InitialisationErrorListener(this){

            @Override
            public void error(String message, Exception e, Logger logger) {
                logger.log(Level.SEVERE, message, e);
                System.exit(9);
            }
        });
        Container.add(PlattformFactory.createPlatformSingleton());
        Container.add(SystemFileChooser.class);
        Container.add(ImageContainer.class);
        Container.add(ImageModelFactory.class);
        PreLoaderTaks preLoaderTask = new PreLoaderTaks();
        this.preLoader.show(primaryStage, preLoaderTask, () -> this.showMainStage());
        new Thread((Runnable)((Object)preLoaderTask)).start();
    }

    private void showMainStage() {
        final Stage primaryStage = new Stage(StageStyle.DECORATED);
        Container.add(primaryStage);
        try {
            LOG.info("---- Greate Component from Autodetection ----");
            Container.createSingletons();
            LOG.info("TIME - AFTER CREATE SINGLETONS : " + (System.currentTimeMillis() - this.time));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Component creation from Autodetection Error", e);
            System.exit(9);
        }
        ApplicationSettings settings = Container.get(ApplicationSettings.class);
        primaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream(DefaultIcons.Window.getLocation()), 32.0, 32.0, false, false));
        double windowWidth = settings.getApplicationWidth();
        double windowHeight = settings.getApplicationHeight();
        if (windowWidth > Screen.getPrimary().getBounds().getWidth()) {
            windowWidth = 800.0;
        }
        if (windowHeight > Screen.getPrimary().getBounds().getHeight()) {
            windowHeight = 600.0;
        }
        OSPlatform plattform = Container.get(OSPlatform.class);
        Scene scene = new Scene((Parent)Container.get(ApplicationViews.class), windowWidth, windowHeight);
        if (!(plattform instanceof WindowsPlatform)) {
            primaryStage.setMinHeight(windowHeight);
            primaryStage.setMinWidth(windowWidth);
        }
        Container.get(Styles.class).setStyle(scene);
        primaryStage.setTitle("Mallongigi");
        primaryStage.setScene(scene);
        if (Container.get(ErrorContainer.class).hasErrors()) {
            new ErrorDialog().showErrorContainer();
        }
        this.stage = primaryStage;
        this.closeSplashScreen();
        Container.get(RefreshAutomaticServices.class).start();
        Container.get(UsbStickAvailableService.class).start();
        new VersionCheck().start();
        primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent e) {
                primaryStage.close();
                try {
                    Main.this.stop();
                }
                catch (Exception e1) {
                    LOG.log(Level.SEVERE, e1.getMessage(), e1);
                }
                System.exit(0);
            }
        });
        primaryStage.show();
        if (!(plattform instanceof WindowsPlatform)) {
            primaryStage.setMinHeight(0.0);
            primaryStage.setMinWidth(0.0);
        }
        plattform.setDarkMode((Window)primaryStage);
        LOG.info("TIME - ALL OVER STAARTTIME : " + (System.currentTimeMillis() - this.time));
    }

    public void stop() throws Exception {
        ApplicationSettings settings = Container.get(ApplicationSettings.class);
        double width = this.stage.getScene().getWidth();
        double height = this.stage.getScene().getHeight();
        Container.get(UsbStickAvailableService.class).cancel();
        Container.get(RefreshAutomaticServices.class).cancel();
        Container.get(ProgressPool.class).stop();
        SaveSettings action = new SaveSettings(settings);
        action.setApplicationHeight(height);
        action.setApplicationWidth(width);
        if (action.execute().booleanValue()) {
            Path txtSettingFile = SettingFile.getSettingFile(FileUtil.FileType.txt);
            FileUtil.delete(txtSettingFile);
        }
        super.stop();
    }

    private void closeSplashScreen() {
        Thread t = new Thread(this){

            @Override
            public void run() {
                SplashScreen splash = SplashScreen.getSplashScreen();
                if (splash == null) {
                    LOG.info("SplashScreen kann nicht erzeugt werden.");
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.info("Thread unterbrochen");
                }
                splash.close();
            }
        };
        t.start();
    }

    private static void initLogger() {
        try {
            String file = System.getProperty("java.util.logging.config.file");
            if (file != null) {
                return;
            }
            Properties properties = new Properties();
            properties.load(((Object)((Object)new Main())).getClass().getResourceAsStream("/de/mallongigi/logging/logging.properties"));
            properties.setProperty("java.util.logging.FileHandler.pattern", FileUtil.getPodcastHomeDirectory().toString() + File.separator + "%g_log.txt");
            StringWriter writer = new StringWriter();
            properties.store(writer, "Log Config");
            ByteArrayInputStream in = new ByteArrayInputStream(writer.toString().getBytes());
            LogManager manager = LogManager.getLogManager();
            manager.readConfiguration(in);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Cant init file Logger.");
        }
    }

    public static void main(String[] args) {
        Platform.setImplicitExit((boolean)false);
        Main.initLogger();
        Application.launch(Main.class, (String[])args);
    }
}

