/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.singleton.scanner;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class JarFileClassScanner {
    private final Path rootPath;

    public JarFileClassScanner(Path path) {
        this.rootPath = path;
    }

    public List<String> scan() throws IOException {
        ArrayList<String> classList = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(this.rootPath.toFile());){
            Enumeration<? extends ZipEntry> list = zipFile.entries();
            while (list.hasMoreElements()) {
                ZipEntry entry = list.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.endsWith(".class") || name.indexOf("$") != -1) continue;
                String className = name.replaceAll("\\/", "\\.");
                className = className.substring(0, className.lastIndexOf(".class"));
                classList.add(className);
            }
        }
        return classList;
    }
}

