/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.singleton.scanner;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public final class FileSystemClassScanner {
    private final Path rootPath;

    public FileSystemClassScanner(Path path) {
        this.rootPath = path;
    }

    public List<String> scan() throws IOException {
        ArrayList<String> classList = new ArrayList<String>();
        try (Stream<Path> walk = Files.walk(this.rootPath, new FileVisitOption[0]);){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path p = (Path)it.next();
                if (!this.isRelevantClass(p)) continue;
                classList.add(this.convertToJava(p));
            }
        }
        return classList;
    }

    private String convertToJava(Path path) {
        StringBuffer result = new StringBuffer("");
        int count = path.getNameCount();
        String rootPath = this.rootPath.toString();
        Object filePath = "";
        boolean isPackage = false;
        for (int i = 0; i < count; ++i) {
            String name = path.getName(i).toString();
            if (!isPackage) {
                filePath = (String)filePath + name;
                isPackage = rootPath.endsWith((String)filePath);
                filePath = (String)filePath + File.separator;
                continue;
            }
            result.append("." + name);
        }
        return result.substring(1, result.indexOf(".class"));
    }

    private boolean isRelevantClass(Path path) {
        String name = path.getFileName().toString();
        if (!name.endsWith(".class") || name.indexOf("$") != -1) {
            return false;
        }
        return !name.equals("package-info.class");
    }
}

