/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.singleton;

import de.mallongigi.singleton.Component;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import de.mallongigi.singleton.scanner.FileSystemClassScanner;
import de.mallongigi.singleton.scanner.JarFileClassScanner;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

final class CreateSingletons {
    private URI location;
    private static final Logger LOG = Logger.getLogger(Container.class.getName());

    public void create() throws Exception {
        CodeSource source = CreateSingletons.class.getProtectionDomain().getCodeSource();
        this.location = source.getLocation().toURI();
        List<String> classList = null;
        LOG.info("Scann " + this.location.toString() + " for Singletons Class");
        switch (this.detectScannProcedure().ordinal()) {
            case 1: {
                LOG.info("Use JarFileClassScanner for scann");
                classList = new JarFileClassScanner(Paths.get(this.location)).scan();
                break;
            }
            case 0: {
                LOG.info("Use FileSystemClassScanner for scann");
                classList = new FileSystemClassScanner(Paths.get(this.location)).scan();
                break;
            }
            default: {
                throw new Exception("Classes are under a source that is not supported. The source is " + String.valueOf(this.location) + " and only files and jars are supported");
            }
        }
        Collections.sort(classList, (p1, p2) -> p1.compareTo((String)p2));
        for (String className : classList) {
            Class<?> cls = Class.forName(className, false, this.getClass().getClassLoader());
            Singleton singleton = cls.getAnnotation(Singleton.class);
            if (singleton != null && singleton.makeAutoInstance()) {
                this.registry(cls);
                continue;
            }
            Component component = cls.getAnnotation(Component.class);
            if (component == null || !component.makeAutoInstance() || !component.singleton()) continue;
            this.registry(cls);
        }
    }

    private void registry(Class<?> cls) {
        LOG.info("Found " + cls.getName() + " as auto Instance Singleton. Try make Instance and registry in Container.");
        if (this.hasInjectFields(cls)) {
            Container.addAndInject(cls);
        } else {
            Container.add(cls);
        }
    }

    private ScanProcedure detectScannProcedure() {
        String path = this.location.getPath();
        if (path.endsWith(".jar") || path.endsWith(".zip")) {
            return ScanProcedure.jar;
        }
        return ScanProcedure.filesystem;
    }

    private boolean hasInjectFields(Class<?> cls) {
        Field[] fields;
        for (Field f : fields = cls.getDeclaredFields()) {
            if (f.getAnnotation(Inject.class) == null) continue;
            return true;
        }
        return false;
    }

    private static enum ScanProcedure {
        filesystem,
        jar;

    }
}

