/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.singleton;

import de.mallongigi.singleton.Component;
import de.mallongigi.singleton.ComponentInstance;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Initialization;
import de.mallongigi.singleton.Singleton;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Logger;

final class ComponentFactory {
    private static final Logger LOG = Logger.getLogger(Container.class.getName());

    ComponentFactory() {
    }

    ComponentInstance create(Class<?> clazz) {
        try {
            Component annotation = clazz.getAnnotation(Component.class);
            Singleton singleton = clazz.getAnnotation(Singleton.class);
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (constructor.getParameterCount() != 0) continue;
                constructor.setAccessible(true);
                Object component = constructor.newInstance(new Object[0]);
                Method initializationMethod = ComponentFactory.getInitializationMethod(component);
                if (annotation == null || singleton != null) {
                    return new ComponentInstance(component, initializationMethod, true);
                }
                return new ComponentInstance(component, initializationMethod, annotation.singleton());
            }
            LOG.severe("Component Class " + clazz.getName() + " has no default Constructor.");
            return null;
        }
        catch (Exception e) {
            LOG.severe("Cant create Instanz of Component  " + clazz.getName() + "\n -> " + e.getMessage());
            return null;
        }
    }

    ComponentInstance create(Object instance) {
        try {
            Component annotation = instance.getClass().getAnnotation(Component.class);
            Method initializationMethod = ComponentFactory.getInitializationMethod(instance);
            if (annotation == null) {
                return new ComponentInstance(instance, initializationMethod, true);
            }
            return new ComponentInstance(instance, initializationMethod, annotation.singleton());
        }
        catch (Exception e) {
            LOG.severe("Cant create Component from Instance " + instance.getClass().getName() + "\n -> " + e.getMessage());
            return null;
        }
    }

    private static Method getInitializationMethod(Object singleton) {
        for (Method m : singleton.getClass().getDeclaredMethods()) {
            if (m.getAnnotation(Initialization.class) == null) continue;
            LOG.info("Auto init Methode found in Class " + singleton.getClass().getName() + " -> Methodname :" + m.getName());
            return m;
        }
        return null;
    }
}

