/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings.json;

import de.mallongigi.settings.model.SettingsParameter;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.Date;
import java.util.Objects;

public final class SettingItem {
    private final JsonObject json;

    SettingItem(JsonObject settings) {
        this.json = settings;
    }

    String get(SettingsParameter parameter) {
        JsonString s = this.json.getJsonString(parameter.name());
        if (s != null) {
            return s.getString();
        }
        return null;
    }

    Long getLong(SettingsParameter parameter) {
        JsonNumber number = this.json.getJsonNumber(parameter.name());
        if (number != null) {
            return number.bigDecimalValue().longValue();
        }
        return null;
    }

    <T> T get(SettingsParameter parameter, T defaultValue) {
        T t = defaultValue;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Double.class, Boolean.class, String.class, Date.class}, t2, n)) {
            case 0: {
                Integer i = (Integer)t2;
                JsonNumber number = this.json.getJsonNumber(parameter.name());
                if (number != null) {
                    return (T)Integer.valueOf(number.bigDecimalValue().intValue());
                }
                return defaultValue;
            }
            case 1: {
                Long i = (Long)t2;
                JsonNumber number = this.json.getJsonNumber(parameter.name());
                if (number != null) {
                    return (T)Long.valueOf(number.bigDecimalValue().longValue());
                }
                return defaultValue;
            }
            case 2: {
                Double i = (Double)t2;
                JsonNumber number = this.json.getJsonNumber(parameter.name());
                if (number != null) {
                    return (T)Double.valueOf(number.bigDecimalValue().doubleValue());
                }
                return defaultValue;
            }
            case 3: {
                Boolean i = (Boolean)t2;
                if (!this.hasProperty(parameter)) {
                    return defaultValue;
                }
                Boolean result = this.json.getBoolean(parameter.name());
                return (T)result;
            }
            case 4: {
                String i = (String)t2;
                String v = this.get(parameter);
                if (v != null) {
                    return (T)v;
                }
                return defaultValue;
            }
            case 5: {
                Date i = (Date)t2;
                if (this.hasProperty(parameter)) {
                    return (T)new Date(this.getLong(parameter));
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + String.valueOf(defaultValue));
    }

    Boolean getBoolean(SettingsParameter parameter) {
        return this.json.getBoolean(parameter.name());
    }

    boolean hasProperty(SettingsParameter parameter) {
        JsonValue o = (JsonValue)this.json.get((Object)parameter.name());
        return o != null;
    }

    JsonArray getArray(SettingsParameter parameter) {
        return this.json.getJsonArray(parameter.name());
    }
}

