/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings.compatible.properties;

import de.mallongigi.platform.OSPlatform;
import de.mallongigi.settings.model.SettingsParameter;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.Properties;

public final class Settings
extends Properties {
    private static final long serialVersionUID = 1L;
    @Inject
    private OSPlatform plattform;

    Settings() {
        Container.inject(this);
    }

    Settings(StringBuffer configArea) throws IOException {
        StringReader reader = new StringReader(configArea.toString());
        this.load(reader);
    }

    Boolean getBoolean(SettingsParameter key) {
        String v = this.getProperty(key.name());
        return Boolean.valueOf(v);
    }

    Boolean getBoolean(SettingsParameter key, boolean defaultValue) {
        String v = this.getProperty(key.name());
        if (v == null) {
            return defaultValue;
        }
        return Boolean.valueOf(v);
    }

    Integer getInteger(SettingsParameter key, Integer defaultValue) {
        String v = this.getProperty(key.name());
        if (v == null) {
            return defaultValue;
        }
        return Integer.valueOf(v);
    }

    double getDouble(SettingsParameter key) {
        String v = this.getProperty(key.name());
        if (v == null) {
            return 0.0;
        }
        return Double.valueOf(v);
    }

    double getDouble(SettingsParameter key, double defaultValue) {
        String v = this.getProperty(key.name());
        if (v == null) {
            return defaultValue;
        }
        return Double.valueOf(v);
    }

    long getLong(SettingsParameter key) {
        String v = this.getProperty(key.name());
        if (v == null) {
            return 0L;
        }
        return Long.valueOf(v);
    }

    String get(SettingsParameter key) {
        return this.getProperty(key.name());
    }

    String get(SettingsParameter key, String defaultValue) {
        return this.getProperty(key.name(), defaultValue);
    }

    Date getDate(SettingsParameter key) {
        String date = this.getProperty(key.name());
        if (date != null && date.length() > 1) {
            return new Date(Long.valueOf(date));
        }
        return null;
    }

    void set(SettingsParameter key, String value) {
        if (value == null) {
            this.setProperty(key.name(), "");
        } else {
            this.setProperty(key.name(), value.trim());
        }
    }

    void set(SettingsParameter key, long value) {
        this.set(key, String.valueOf(value));
    }

    void set(SettingsParameter key, double value) {
        this.set(key, String.valueOf(value));
    }

    void set(SettingsParameter key, boolean value) {
        this.set(key, String.valueOf(value));
    }

    void set(SettingsParameter key, Date value) {
        if (value == null) {
            this.set(key, String.valueOf(this.plattform.getSystemDate()));
        } else {
            this.set(key, String.valueOf(value.getTime()));
        }
    }

    void set(SettingsParameter key, Enum value) {
        if (value == null) {
            return;
        }
        this.set(key, value.name());
    }

    boolean hasProperty(SettingsParameter key) {
        return this.containsKey(key.name());
    }
}

