/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings.compatible.properties;

import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.settings.LoadSettingsInterface;
import de.mallongigi.settings.compatible.ConvertOldEpisodeFileNames;
import de.mallongigi.settings.compatible.properties.SettingsParser;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.start.preload.PreLoadTaskInterface;
import java.io.BufferedReader;

public abstract class SettingFlatFormatLoader
implements LoadSettingsInterface {
    private SettingsParser parser;
    private ApplicationSettings result = new ApplicationSettings();
    private PreLoadTaskInterface task;

    public SettingFlatFormatLoader(PreLoadTaskInterface task) {
        this.task = task;
        this.parser = new SettingsParser(this.result);
    }

    public void parse(BufferedReader reader, long progress, long size) throws Exception {
        String line = null;
        StringBuffer buffer = new StringBuffer();
        PodcastChannelModel currentChannel = null;
        while ((line = reader.readLine()) != null) {
            this.task.update(progress += (long)line.getBytes().length, size);
            if (line.startsWith("##")) {
                if (buffer.indexOf("=") == -1 || buffer.charAt(0) != '#') {
                    buffer = new StringBuffer(line);
                    continue;
                }
                currentChannel = this.parseChannelDetails(buffer, currentChannel);
                buffer = new StringBuffer(line);
                continue;
            }
            buffer.append(line + "\n");
        }
        this.parseChannelDetails(buffer, currentChannel);
    }

    public void finish() {
        if (this.parser.isRunFileNameCoverterProcess()) {
            new ConvertOldEpisodeFileNames(this.result.getChannels(), this.task).convert();
        }
    }

    private PodcastChannelModel parseChannelDetails(StringBuffer buffer, PodcastChannelModel currentChannel) {
        PodcastEpisodeModel episode;
        if (buffer.indexOf("#MAIN_WINDOW") == 1) {
            this.parser.parseMainWindow(buffer);
            return null;
        }
        if (buffer.indexOf("#Podcast Channel") == 1) {
            currentChannel = this.parser.parseChannel(buffer);
            this.result.add(currentChannel);
            this.task.update(currentChannel.getTitle());
        }
        if (buffer.indexOf("#Podcast Item") == 1 && currentChannel != null && (episode = this.parser.parseChannelItem(buffer, currentChannel)) != null) {
            currentChannel.unsavedAdd(episode);
        }
        return currentChannel;
    }

    @Override
    public ApplicationSettings getResult() {
        return this.result;
    }
}

