/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings.compatible.properties;

import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.settings.LoadSettingsInterface;
import de.mallongigi.settings.compatible.properties.SettingsParser;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.start.preload.PreLoadTaskInterface;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class MultiEntryZipFileSettingLoader
implements LoadSettingsInterface {
    private static final Logger LOG = Logger.getLogger(MultiEntryZipFileSettingLoader.class.getName());
    private SettingsParser parser;
    private PreLoadTaskInterface task;
    private ApplicationSettings result = new ApplicationSettings();
    private long fileSize = 0L;
    private long progress = 0L;
    private DisplayTaksList displayTaskList = new DisplayTaksList();

    public MultiEntryZipFileSettingLoader(PreLoadTaskInterface task) {
        this.task = task;
        this.parser = new SettingsParser(this.result);
    }

    @Override
    public void load(Path file) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ZipFile zipFile = new ZipFile(file.toFile());
        try {
            Enumeration<? extends ZipEntry> list = zipFile.entries();
            block13: while (list.hasMoreElements()) {
                ZipEntry entry = list.nextElement();
                this.fileSize += entry.getSize();
                switch (entry.getName()) {
                    case "version.txt": {
                        continue block13;
                    }
                    case "settings.txt": {
                        this.parser.parseMainWindow(this.readEntry(zipFile.getInputStream(entry)));
                        continue block13;
                    }
                }
                executor.execute(new ChannelDataParser(this.parser, zipFile.getInputStream(entry)));
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.MINUTES);
            zipFile.close();
        }
    }

    private StringBuffer readEntry(InputStream in) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            this.progress += (long)line.getBytes().length;
            this.task.update(this.progress, this.fileSize);
            buffer.append(line + "\n");
        }
        return buffer;
    }

    @Override
    public ApplicationSettings getResult() {
        return this.result;
    }

    private class DisplayTaksList {
        private ReentrantLock lock = new ReentrantLock();
        private List<String> workingChannelNames = Collections.synchronizedList(new ArrayList());

        private DisplayTaksList() {
        }

        private void add(String taskName) {
            try {
                this.lock.lock();
                this.workingChannelNames.add(taskName);
                this.update();
            }
            finally {
                this.lock.unlock();
            }
        }

        private void remove(String taskName) {
            try {
                this.lock.lock();
                this.workingChannelNames.remove(taskName);
                this.update();
            }
            finally {
                this.lock.unlock();
            }
        }

        private void update() {
            Object names = "";
            for (String n : this.workingChannelNames) {
                names = (String)names + "\"" + n + "\" ";
            }
            MultiEntryZipFileSettingLoader.this.task.update((String)names);
        }
    }

    private class ChannelDataParser
    implements Runnable {
        private SettingsParser parser;
        private InputStream in;

        private ChannelDataParser(SettingsParser parser, InputStream in) {
            this.parser = parser;
            this.in = in;
        }

        @Override
        public void run() {
            try {
                String line;
                String searchString = "##Podcast Item";
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.in, StandardCharsets.UTF_8));
                StringBuffer buffer = new StringBuffer();
                PodcastChannelModel channel = null;
                while ((line = reader.readLine()) != null) {
                    MultiEntryZipFileSettingLoader.this.progress += (long)line.getBytes().length;
                    MultiEntryZipFileSettingLoader.this.task.update(MultiEntryZipFileSettingLoader.this.progress, MultiEntryZipFileSettingLoader.this.fileSize);
                    if (line.startsWith(searchString)) {
                        if (channel == null) {
                            channel = this.parser.parseChannel(buffer);
                            MultiEntryZipFileSettingLoader.this.displayTaskList.add(channel.getTitle());
                            MultiEntryZipFileSettingLoader.this.result.add(channel);
                            buffer = new StringBuffer();
                            continue;
                        }
                        PodcastEpisodeModel episode = this.parser.parseChannelItem(buffer, channel);
                        channel.unsavedAdd(episode);
                        buffer = new StringBuffer();
                        continue;
                    }
                    buffer.append(line + "\n");
                }
                channel.add(this.parser.parseChannelItem(buffer, channel));
                MultiEntryZipFileSettingLoader.this.displayTaskList.remove(channel.getTitle());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

