/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings.compatible.properties;

import de.mallongigi.settings.compatible.properties.SettingFlatFormatLoader;
import de.mallongigi.start.preload.PreLoadTaskInterface;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class FlatZipFileSettingLoader
extends SettingFlatFormatLoader {
    public FlatZipFileSettingLoader(PreLoadTaskInterface task) {
        super(task);
    }

    @Override
    public void load(Path file) throws Exception {
        try (ZipFile zipFile = new ZipFile(file.toFile());){
            ZipEntry zipEntry = zipFile.getEntry("settings.txt");
            if (zipEntry == null || zipEntry.getSize() == 0L) {
                throw new Exception("Cant read Settings");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry), StandardCharsets.UTF_8));
            long size = zipEntry.getSize();
            long progress = 0L;
            this.parse(reader, progress, size);
        }
        this.finish();
    }
}

