/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings;

import de.mallongigi.podcast.channel.ui.RefreshAutomaticServices;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Component;
import de.mallongigi.singleton.Initialization;
import de.mallongigi.singleton.Inject;
import de.mallongigi.toolbar.usbstick.UsbStickAvailableService;
import de.mallongigi.ui.elements.UIButton;
import de.mallongigi.ui.elements.UILabel;
import java.io.File;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;

@Component
public final class SettingPane
extends GridPane {
    @Inject
    private LanguageResource languageResource;
    @Inject
    private UsbStickAvailableService usbStickAvailableService;
    @Inject
    private RefreshAutomaticServices registryAutomaticServices;
    @Inject
    private ApplicationSettings settings;
    @Inject(safety=false)
    private Stage primaryStage;

    private SettingPane() {
    }

    @Initialization
    private void init() {
        this.setHgap(10.0);
        this.setVgap(10.0);
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        TextField ffmpegath = this.getTextField(this.settings.getConverterPathProperty(), LanguageKeys.ffmpegPath);
        this.add((Node)new UILabel(LanguageKeys.ffmpegPath), 0, 0);
        this.add((Node)ffmpegath, 1, 0);
        this.add((Node)this.getFileSelectionButton(LanguageKeys.browse, this.settings.getConverterPathProperty(), LanguageKeys.ffmpegPath, "ffmpeg", "ffmpeg.*"), 2, 0);
        Spinner automaticRefreshTime = new Spinner(5, 480, this.settings.getAutomaticRefreshTimerProperty().get());
        automaticRefreshTime.setId(LanguageKeys.automaticRefreshTimer.name());
        automaticRefreshTime.getValueFactory().valueProperty().bindBidirectional((Property)this.settings.getAutomaticRefreshTimerProperty().asObject());
        automaticRefreshTime.focusedProperty().addListener((ov, oldV, hasFocus) -> {
            if (!hasFocus.booleanValue()) {
                Duration durationValue = Duration.minutes((double)((Integer)automaticRefreshTime.getValue()).intValue());
                if (!this.registryAutomaticServices.getPeriod().equals((Object)durationValue)) {
                    this.registryAutomaticServices.setPeriod(durationValue);
                    this.registryAutomaticServices.restart();
                }
            }
        });
        this.add((Node)new UILabel(LanguageKeys.automaticRefreshTimer), 0, 1);
        this.add((Node)automaticRefreshTime, 1, 1);
        TextField usbStickPathFiled = this.getTextField(this.settings.getUsbStickPathProperty(), LanguageKeys.usbStick);
        this.add((Node)new UILabel(LanguageKeys.usbStick), 0, 2);
        this.add((Node)usbStickPathFiled, 1, 2);
        this.add((Node)this.getDirectorySelectionButton(LanguageKeys.browse, this.settings.getUsbStickPathProperty(), LanguageKeys.usbStick), 2, 2);
        usbStickPathFiled.focusedProperty().addListener((ov, oldV, hasFocus) -> {
            if (!hasFocus.booleanValue()) {
                this.usbStickAvailableService.updateNow();
            }
        });
        ToggleGroup mediaPlayerToggleGroup = new ToggleGroup();
        RadioButton mediaPlayerIntern = new RadioButton("Use internal Media-Player");
        mediaPlayerIntern.setToggleGroup(mediaPlayerToggleGroup);
        mediaPlayerIntern.setUserData((Object)"internal");
        mediaPlayerIntern.setSelected(this.settings.isUseInternalMediaPlayer());
        RadioButton mediaPlayerextern = new RadioButton("Use external Media-Player");
        mediaPlayerextern.setToggleGroup(mediaPlayerToggleGroup);
        mediaPlayerextern.setUserData((Object)"external");
        mediaPlayerextern.setSelected(!mediaPlayerIntern.isSelected());
        mediaPlayerToggleGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> arg0, Toggle arg1, Toggle arg2) {
                SettingPane.this.settings.setUseInternalMediaPlayer(arg2.getUserData().toString().equals("internal"));
            }
        });
        this.add((Node)mediaPlayerIntern, 0, 4);
        this.add((Node)mediaPlayerextern, 0, 5);
        GridPane.setHgrow((Node)ffmpegath, (Priority)Priority.ALWAYS);
    }

    private TextField getTextField(SimpleStringProperty dataBinding, LanguageKeys id) {
        TextField field = new TextField();
        field.textProperty().bindBidirectional((Property)dataBinding);
        field.setId(id.name());
        return field;
    }

    private UIButton getFileSelectionButton(LanguageKeys text, final SimpleStringProperty dataBinding, final LanguageKeys dialogTitle, final String filterName, final String ... filterExtention) {
        UIButton button = new UIButton(text, DefaultIcons.OpenFolder);
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle(SettingPane.this.languageResource.messageForKey(dialogTitle));
                fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(filterName, filterExtention)});
                File file = fileChooser.showOpenDialog((Window)SettingPane.this.primaryStage);
                if (file != null) {
                    dataBinding.set(file.getAbsolutePath());
                }
            }
        });
        return button;
    }

    private UIButton getDirectorySelectionButton(LanguageKeys text, final SimpleStringProperty dataBinding, final LanguageKeys dialogTitle) {
        UIButton button = new UIButton(text, DefaultIcons.OpenFolder);
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DirectoryChooser fileChooser = new DirectoryChooser();
                fileChooser.setTitle(SettingPane.this.languageResource.messageForKey(dialogTitle));
                File file = fileChooser.showDialog((Window)SettingPane.this.primaryStage);
                if (file != null) {
                    dataBinding.set(file.getAbsolutePath());
                }
            }
        });
        return button;
    }
}

