/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings;

import de.mallongigi.platform.PlattformFactory;
import de.mallongigi.settings.LoadSettingsInterface;
import de.mallongigi.settings.RegistryNumberGenerator;
import de.mallongigi.settings.SettingFile;
import de.mallongigi.settings.compatible.properties.FlatZipFileSettingLoader;
import de.mallongigi.settings.compatible.properties.MultiEntryZipFileSettingLoader;
import de.mallongigi.settings.compatible.properties.TextFileSettingLoader;
import de.mallongigi.settings.json.JSONSettingLoader;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.settings.model.SettingsParameter;
import de.mallongigi.start.preload.PreLoadTaskInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class LoadSettings {
    private final PreLoadTaskInterface task;

    public LoadSettings(PreLoadTaskInterface task) {
        this.task = task;
    }

    public ApplicationSettings execute() throws Exception {
        if (!SettingFile.exsistsSettingFile()) {
            ApplicationSettings settings = new ApplicationSettings();
            settings.setApplicationHeight(600.0);
            settings.setApplicationWidth(800.0);
            settings.setRegistryNumber(RegistryNumberGenerator.createNumber());
            settings.setFfmpegPath(PlattformFactory.createPlatformSingleton().getFFMPEGDefaulPath());
            return settings;
        }
        LoadSettingsInterface loader = null;
        switch (SettingFile.getCurrentSettingFileType()) {
            case txt: {
                loader = new TextFileSettingLoader(this.task);
                break;
            }
            case zip: {
                loader = this.createZipFileLoader();
                break;
            }
            default: {
                return new ApplicationSettings();
            }
        }
        loader.load(SettingFile.getSettingFile());
        return loader.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadSettingsInterface createZipFileLoader() throws Exception {
        try (ZipFile zipFile = new ZipFile(SettingFile.getSettingFile().toFile());){
            ZipEntry entry = zipFile.getEntry("version.txt");
            if (entry == null) {
                FlatZipFileSettingLoader flatZipFileSettingLoader = new FlatZipFileSettingLoader(this.task);
                return flatZipFileSettingLoader;
            }
            int version = this.getSettingsVersion(zipFile.getInputStream(entry));
            if (version <= 2) {
                MultiEntryZipFileSettingLoader multiEntryZipFileSettingLoader = new MultiEntryZipFileSettingLoader(this.task);
                return multiEntryZipFileSettingLoader;
            }
            JSONSettingLoader jSONSettingLoader = new JSONSettingLoader(this.task);
            return jSONSettingLoader;
        }
    }

    private int getSettingsVersion(InputStream in) throws IOException {
        Properties p = new Properties();
        p.load(new InputStreamReader(in, StandardCharsets.UTF_8));
        String version = p.get(SettingsParameter.settingVersion.name()).toString();
        return Integer.parseInt(version);
    }
}

