/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.resource.icons;

import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconColors;
import de.mallongigi.resource.icons.SVGLoader;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import de.mallongigi.ui.style.Styles;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

@Singleton
public final class IconFactory {
    @Inject
    private Styles styles;

    private IconFactory() {
    }

    public Node create(DefaultIcons image, int imageSize, IconColors iconColor) {
        switch (image.getIconFormat()) {
            case PIXEL: {
                return new ImageView(this.createIcon(image, imageSize));
            }
            case SVG_PATH: {
                return new SVGLoader().get(image, imageSize, iconColor);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)image.getIconFormat()) + " is not know and cant build JavaFx UI Component.");
    }

    public Node create(DefaultIcons image, int imageSize) {
        return this.create(image, imageSize, IconColors.Default);
    }

    public Node create(DefaultIcons image) {
        return this.create(image, 32, IconColors.Default);
    }

    public Image createIcon(DefaultIcons imageLocation, int size) {
        return new Image(this.getClass().getResourceAsStream(imageLocation.getLocation()), (double)size, (double)size, false, false);
    }
}

