/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.search;

import de.mallongigi.images.PixelImageLoader;
import de.mallongigi.images.model.ImageModelFactory;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.channel.ui.AddPodcastChannelService;
import de.mallongigi.podcast.search.ITunesImageDownloadPool;
import de.mallongigi.podcast.search.SearchService;
import de.mallongigi.podcast.search.itunes.ITunesItem;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.images.DefaultImages;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.elements.UIButton;
import de.mallongigi.ui.elements.UILink;
import de.mallongigi.ui.style.BasicCssClasses;
import de.mallongigi.ui.style.Styles;
import de.mallongigi.views.ApplicationViewNames;
import de.mallongigi.views.ApplicationViewsModel;
import java.util.ArrayList;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public final class PodcastSearchPane {
    private static final Logger LOG = Logger.getLogger(PodcastSearchPane.class.getName());
    @Inject
    private LanguageResource languageResource;
    @Inject
    private ApplicationViewsModel viewModel;
    @Inject
    private Styles styles;
    @Inject
    private PodcastChannelContainer podcastChannelContainer;
    @Inject
    private AddPodcastChannelService addPodcastChannelService;
    @Inject(safety=false)
    private Stage primaryStage;
    @Inject
    private ImageModelFactory imageModelFactory;
    private final BorderPane root = new BorderPane();
    private final UIButton searchButton = new UIButton(LanguageKeys.search, DefaultIcons.search);
    private final TextField searchText = new TextField();
    private final VBox resultView = new VBox();
    private final SearchService service;
    private final ITunesImageDownloadPool imageDownloadPool = new ITunesImageDownloadPool();

    public PodcastSearchPane() {
        Container.inject(this);
        this.init();
        this.service = new SearchService(this);
    }

    private void init() {
        HBox searchPane = new HBox();
        this.searchText.setPrefWidth(500.0);
        this.searchText.setPromptText(this.languageResource.messageForKey(LanguageKeys.searchQuery));
        Label label = new Label(this.languageResource.messageForKey(LanguageKeys.search));
        this.searchButton.setDisable(true);
        searchPane.setSpacing(10.0);
        searchPane.setAlignment(Pos.BASELINE_CENTER);
        searchPane.getChildren().addAll((Object[])new Node[]{label, this.searchText, this.searchButton});
        ScrollPane scrollResultPane = new ScrollPane((Node)this.resultView);
        scrollResultPane.setFitToWidth(true);
        scrollResultPane.setFitToHeight(true);
        this.root.setTop((Node)searchPane);
        this.root.setCenter((Node)scrollResultPane);
        this.searchText.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER) && PodcastSearchPane.this.searchText.getText().length() >= 3) {
                    PodcastSearchPane.this.search();
                } else {
                    PodcastSearchPane.this.searchButton.setDisable(PodcastSearchPane.this.searchText.getText().length() < 3);
                }
            }
        });
        this.searchButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                if (PodcastSearchPane.this.searchText.getText().length() >= 3) {
                    PodcastSearchPane.this.search();
                }
            }
        });
    }

    private void search() {
        this.primaryStage.getScene().setCursor(Cursor.WAIT);
        this.searchButton.setDisable(true);
        this.searchText.setDisable(true);
        this.resultView.getChildren().clear();
        this.service.setQuery(this.searchText.getText());
        this.service.start();
    }

    void setResult(ITunesItem[] items) {
        try {
            this.service.reset();
            if (items == null) {
                this.noResult();
                return;
            }
            ArrayList<HBox> nodeList = new ArrayList<HBox>();
            this.resultView.getChildren().clear();
            for (ITunesItem i : items) {
                try {
                    nodeList.add(this.getItem(i));
                }
                catch (Exception e) {
                    LOG.info(e.getMessage());
                }
                if (nodeList.size() > 80) break;
            }
            this.resultView.getChildren().clear();
            this.resultView.getChildren().addAll(nodeList);
            this.searchButton.setDisable(false);
            this.searchText.setDisable(false);
            this.primaryStage.getScene().setCursor(Cursor.DEFAULT);
        }
        catch (Exception e) {
            this.noResult();
        }
    }

    void noResult() {
        this.searchButton.setDisable(false);
        this.searchText.setDisable(false);
        this.resultView.getChildren().add((Object)new Label("No Result"));
        this.primaryStage.getScene().setCursor(Cursor.DEFAULT);
    }

    private HBox getItem(final ITunesItem item) {
        HBox root = new HBox();
        root.setSpacing(10.0);
        this.styles.setStyle((Node)root, BasicCssClasses.defaultBackground);
        root.setAlignment(Pos.CENTER_LEFT);
        Label name = new Label(item.getName());
        this.styles.setStyle((Node)name, BasicCssClasses.title);
        Label country = new Label(item.getCountry());
        Label artist = new Label(item.getArtist());
        Label episodeCount = new Label(String.valueOf(item.getEpsiodeCount()));
        VBox content = new VBox();
        content.setSpacing(10.0);
        content.getChildren().addAll((Object[])new Node[]{name, artist, country, episodeCount, new UILink(item.getHomepageUrl())});
        Image image = new PixelImageLoader().create(this.imageModelFactory.create(DefaultImages.RSS), 100).image();
        VBox genres = new VBox();
        genres.setMinWidth(200.0);
        for (String g : item.getGenres()) {
            genres.getChildren().add((Object)new Label(g));
        }
        boolean addPodcastDisable = false;
        for (PodcastChannelModel channel : this.podcastChannelContainer.getPodcastChannels(PodcastNavigationViewType.Podcast)) {
            if (!channel.getPodcastFeedUrl().equals(item.getFeedUrl())) continue;
            addPodcastDisable = true;
            break;
        }
        final UIButton addRssFeedButton = new UIButton(LanguageKeys.addPodcast, DefaultIcons.AddPodcast);
        addRssFeedButton.setDisable(addPodcastDisable);
        addRssFeedButton.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                PodcastSearchPane.this.addPodcastChannelService.setUrl(item.getFeedUrl()).setShowAlternative(true).restart();
                addRssFeedButton.setDisable(true);
                PodcastSearchPane.this.viewModel.setView(ApplicationViewNames.Podcasts);
            }
        });
        root.getChildren().addAll((Object[])new Node[]{new ImageView(image), addRssFeedButton, genres, content});
        root.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
        this.imageDownloadPool.add(item, root);
        return root;
    }

    public BorderPane getRoot() {
        return this.root;
    }
}

