/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.progress;

import de.mallongigi.images.model.ImageIconModel;
import de.mallongigi.images.model.ImageModel;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.channel.model.PodcastChannelFeedType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.model.Model;
import de.mallongigi.podcast.progress.AbstractProgressHandler;
import de.mallongigi.podcast.progress.ChannelListRefreshHandler;
import de.mallongigi.podcast.progress.ChannelRefreshHandler;
import de.mallongigi.podcast.progress.ClearChannelDataHandler;
import de.mallongigi.podcast.progress.EpisodeClearMP3Handler;
import de.mallongigi.podcast.progress.EpisodeConvertHandler;
import de.mallongigi.podcast.progress.EpisodeCopyHandler;
import de.mallongigi.podcast.progress.EpisodeDownloadHandler;
import de.mallongigi.podcast.progress.ImageDownloadHandler;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressExecutor;
import de.mallongigi.podcast.progress.ProgressFinishListener;
import de.mallongigi.podcast.progress.ProgressList;
import de.mallongigi.podcast.progress.ProgressModel;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.images.DefaultImages;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import de.mallongigi.ui.concurrent.JavaFXUtil;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@Singleton
public final class ProgressPool {
    private static final Logger LOG = Logger.getLogger(ProgressPool.class.getName());
    @Inject
    private ProgressList progressList;
    @Inject(safety=false)
    private ReentrantLock uiLocker;
    @Inject
    private OSPlatform plattfrom;
    @Inject
    private ApplicationSettings settings;
    private final ProgressExecutor executor = new ProgressExecutor();

    public void stop() {
        this.executor.shutdownNow();
        for (AbstractProgressHandler<? extends Model> m : this.progressList.items()) {
            m.handleCancel();
        }
    }

    private ProgressFinishListener getFinishListener(AbstractProgressHandler<? extends Model> progressHandler) {
        return new ProgressFinishListener(){

            @Override
            public void ready(final AbstractProgressHandler<? extends Model> progressHandler) {
                if (progressHandler == null) {
                    return;
                }
                LOG.info("ProgressPool Ready Handler " + String.valueOf(progressHandler.getClass()) + " / " + progressHandler.model.getTitle());
                JavaFXUtil.runLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressPool.this.progressList.remove(progressHandler);
                    }
                });
            }
        };
    }

    public void addImageDownload(ImageModel image, Model targetModel) {
        try {
            this.add(new ImageDownloadHandler(targetModel, image));
        }
        catch (Exception e) {
            if (targetModel != null) {
                LOG.log(Level.INFO, "Cant Download Image from '" + targetModel.getImageURL() + "'", e);
            }
            LOG.log(Level.INFO, "Cant Dowload Image: targetModel is null.", e);
        }
    }

    public void add(List<PodcastChannelModel> channelList) {
        ProgressModel<PodcastChannelModel> model = new ProgressModel<PodcastChannelModel>(DefaultIcons.DownloadEpisode);
        ChannelListRefreshHandler handler = new ChannelListRefreshHandler(channelList, model);
        handler.addFinishListener(this.getFinishListener(handler));
        try {
            this.add(handler);
        }
        catch (Exception e) {
            model.setErrorMessage(LanguageKeys.errorMessageExecuteProgress);
            model.setErrorMessageDetails(e);
            handler.executeFinishListener();
            LOG.log(Level.INFO, model.getTitle(), e);
        }
    }

    public void add(PodcastChannelModel channel) {
        ChannelRefreshHandler handler = new ChannelRefreshHandler(channel);
        handler.addFinishListener(this.getFinishListener(handler));
        try {
            handler.getProgressModel().setInProgress(true);
            this.add(handler);
        }
        catch (Exception e) {
            handler.getProgressModel().setErrorMessage(LanguageKeys.errorMessageExecuteProgress);
            handler.getProgressModel().setErrorMessageDetails(e);
            handler.executeFinishListener();
            LOG.log(Level.INFO, handler.getProgressModel().getTitle(), e);
        }
    }

    public void addClearData() {
        ClearChannelDataHandler handler = new ClearChannelDataHandler();
        try {
            Long time = this.settings.getLastCleanTime();
            if (time != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(time);
                int clearWeek = calendar.get(3);
                calendar.setTimeInMillis(this.plattfrom.getSystemTime());
                int currentWeek = calendar.get(3);
                LOG.info(String.format("Last Data Clear Week %d ; This Week is %d", clearWeek, currentWeek));
                if (clearWeek == currentWeek) {
                    return;
                }
            }
            handler.addFinishListener(this.getFinishListener(handler));
            handler.getProgressModel().setImage(new ImageIconModel(DefaultImages.clear));
            handler.getProgressModel().setTitle("Clear Datas");
            this.add(handler);
        }
        catch (Exception e) {
            handler.getProgressModel().setErrorMessage(LanguageKeys.errorMessageExecuteProgress);
            handler.getProgressModel().setErrorMessageDetails(e);
            handler.executeFinishListener();
            LOG.log(Level.INFO, handler.getProgressModel().getTitle(), e);
        }
    }

    public boolean add(PodcastEpisodeModel episode, ProgressAction action) {
        boolean result;
        block9: {
            AbstractProgressHandler handler = null;
            result = false;
            try {
                switch (action) {
                    case convert: {
                        handler = new EpisodeConvertHandler(episode);
                        handler.addFinishListener(this.getFinishListener(handler));
                        result = this.add(handler);
                        break;
                    }
                    case copyToUsb: {
                        handler = new EpisodeCopyHandler(episode, episode.getChannel().getFeedType() == PodcastChannelFeedType.Audiothek);
                        handler.addFinishListener(this.getFinishListener(handler));
                        result = this.add(handler);
                        break;
                    }
                    case download: {
                        handler = new EpisodeDownloadHandler(episode);
                        handler.addFinishListener(this.getFinishListener(handler));
                        result = this.add(handler);
                        break;
                    }
                    case clearMP3: {
                        handler = new EpisodeClearMP3Handler(episode);
                        handler.addFinishListener(this.getFinishListener(handler));
                        result = this.add(handler);
                        break;
                    }
                    case imageDownload: {
                        throw new IllegalArgumentException("Cant work with action  imageDownload use addImageDownload Methode for download a image.");
                    }
                }
            }
            catch (Exception e) {
                if (handler == null) break block9;
                handler.executeFinishListener();
                ProgressModel model = handler.getProgressModel();
                if (model == null) break block9;
                model.setErrorMessage(LanguageKeys.errorClearFile);
                model.setErrorMessageDetails(e);
            }
        }
        episode.getState().setInPool(result);
        return result;
    }

    private boolean add(AbstractProgressHandler<? extends Model> progressHandler) {
        if (this.progressList.contains(progressHandler)) {
            return false;
        }
        JavaFXUtil.optionalRunLater(() -> {
            if (progressHandler.getActionType() != ProgressAction.imageDownload) {
                this.progressList.add(progressHandler);
            }
            this.executor.execute(progressHandler);
        });
        return true;
    }
}

