/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.progress;

import de.mallongigi.images.model.ImageIconModel;
import de.mallongigi.podcast.model.Model;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.images.DefaultImages;
import de.mallongigi.resource.language.LanguageKeys;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public final class ProgressModel<T extends Model>
implements Comparable<T> {
    private ImageIconModel image = new ImageIconModel(DefaultImages.RSS);
    private final StringProperty title = new SimpleStringProperty();
    private T model;
    private boolean inProgress = false;
    private LanguageKeys errorMessage;
    private Exception errorMessageDetails;

    ProgressModel() {
    }

    ProgressModel(DefaultIcons icon) {
        this.image.setImageIcon(icon);
    }

    ProgressModel(T model) {
        this.model = model;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    public ImageIconModel getImage() {
        return this.image;
    }

    void setImage(ImageIconModel image) {
        this.image = image;
    }

    public String getTitle() {
        return this.title.getValue();
    }

    void setTitle(String title) {
        this.title.setValue(title);
    }

    StringProperty getTitleProperty() {
        return this.title;
    }

    public T getModel() {
        return this.model;
    }

    public void setErrorMessage(LanguageKeys errorMessage) {
        this.errorMessage = errorMessage;
    }

    public LanguageKeys getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessageDetails(Exception errorMessageDetails) {
        this.errorMessageDetails = errorMessageDetails;
    }

    public Exception getErrorMessageDetails() {
        return this.errorMessageDetails;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        result = 31 * result + (this.errorMessageDetails == null ? 0 : this.errorMessageDetails.hashCode());
        result = 31 * result + (this.image == null ? 0 : this.image.hashCode());
        result = 31 * result + (this.isInProgress() ? 1231 : 1237);
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof ProgressModel) {
            ProgressModel pm = (ProgressModel)obj;
            T incomeModel = pm.getModel();
            if (incomeModel == null && this.getModel() == null) {
                if (pm.getTitle() != null && this.getTitle() != null) {
                    return pm.getTitle().equals(this.getTitle());
                }
            } else {
                if (incomeModel == null && this.getModel() != null) {
                    return false;
                }
                if (incomeModel != null && this.getModel() == null) {
                    return false;
                }
                return incomeModel.equals(this.getModel());
            }
        }
        return false;
    }

    @Override
    public int compareTo(T model) {
        if (model == null) {
            return 1;
        }
        if (this.inProgress) {
            return -1;
        }
        String title = model.getTitle();
        if (title == null) {
            return -1;
        }
        if (this.getTitle() == null) {
            return 1;
        }
        return this.getTitle().compareTo(title);
    }
}

