/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.progress;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.file.FileCopyToUsbPath;
import de.mallongigi.images.model.ImageIconModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.progress.AbstractProgressHandler;
import de.mallongigi.podcast.progress.ApplicationTask;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressModel;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Inject;
import de.mallongigi.time.DateTimeConverter;
import de.mallongigi.toolbar.ApplicationToolbarModel;
import de.mallongigi.toolbar.usbstick.USBComponentModel;
import java.time.LocalTime;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public final class EpisodeCopyHandler
extends AbstractProgressHandler<PodcastEpisodeModel> {
    private static final Logger LOG = Logger.getLogger(EpisodeCopyHandler.class.getName());
    @Inject(safety=false)
    private ReentrantLock uiLocker;
    @Inject
    private ApplicationToolbarModel applicationToolbarModel;
    @Inject
    private DateTimeConverter dateTimeConverter;
    @Inject
    private ApplicationSettings settings;
    @Inject
    private DateTimeConverter durationFormat;
    private USBComponentModel usbComponentModel;
    private boolean createAlias = false;
    private boolean cancel = false;

    EpisodeCopyHandler(PodcastEpisodeModel episode, boolean createAlias) {
        super(new ProgressModel<PodcastEpisodeModel>(episode), ProgressAction.copyToUsb);
        this.getProgressModel().setTitle(episode.getTitle());
        this.getProgressModel().setImage(new ImageIconModel(episode.getImage().getLocation(), episode.getImage().getDeviceType(), DefaultIcons.copyToStick));
        this.usbComponentModel = this.findUSBComponent();
        this.addFinishListener(l -> {
            LanguageKeys errorMessage = this.model.getErrorMessage();
            Exception detail = this.model.getErrorMessageDetails();
            if (errorMessage != null) {
                new ErrorDialog().show(errorMessage, detail, this.model.getTitle());
            }
            ((PodcastEpisodeModel)this.model.getModel()).getState().setInPool(false);
            this.applicationToolbarModel.refresh(((PodcastEpisodeModel)this.model.getModel()).getChannel());
            this.usbComponentModel.setCopyMode(false);
        });
        this.createAlias = createAlias;
    }

    private USBComponentModel findUSBComponent() {
        String usbPath = ((PodcastEpisodeModel)this.model.getModel()).getChannel().getUsbPath();
        if (usbPath == null || usbPath.isEmpty()) {
            usbPath = this.settings.getUsbStickPathProperty().get();
        }
        return this.applicationToolbarModel.getUsbList().find(usbPath);
    }

    public boolean createAlias() {
        return this.createAlias;
    }

    @Override
    void handleCancel() {
        this.cancel = true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public ApplicationTask prepareProgress() throws Exception {
        FileCopyToUsbPath handler = new FileCopyToUsbPath(this);
        if (this.usbComponentModel != null && !handler.targetFileExists()) {
            try {
                this.usbComponentModel.setCopyMode(true);
                LocalTime duration = this.dateTimeConverter.convertDurationTime(((PodcastEpisodeModel)this.model.getModel()).getDuration());
                LocalTime completeDuration = this.dateTimeConverter.convertDurationTime((String)this.usbComponentModel.getCompleteDuration().get());
                LocalTime d = LocalTime.of(0, 0, 0);
                d = d.plusSeconds(completeDuration.getSecond()).plusMinutes(completeDuration.getMinute()).plusHours(completeDuration.getHour());
                d = d.plusSeconds(duration.getSecond()).plusMinutes(duration.getMinute()).plusHours(duration.getHour());
                this.usbComponentModel.getCompleteDuration().set((Object)this.dateTimeConverter.getDurationFormatter().format(d));
                String fileSize = (String)this.usbComponentModel.fileSizeProperty().get();
                if (fileSize != null) {
                    int size = Integer.valueOf(fileSize) + 1;
                    this.usbComponentModel.fileSizeProperty().set((Object)String.valueOf(size));
                }
            }
            catch (Exception e) {
                LOG.finest("No Problem... EpisodeCopyHandler.prepareProgress() has a Exception " + e.getLocalizedMessage());
            }
        }
        return handler;
    }
}

