/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.progress;

import de.mallongigi.http.feed.RefreshPodcastChannelClient;
import de.mallongigi.images.model.ImageIconModel;
import de.mallongigi.podcast.channel.model.RefreshPodcastChannelModel;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.model.UIState;
import de.mallongigi.podcast.progress.AbstractProgressHandler;
import de.mallongigi.podcast.progress.ApplicationTask;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressModel;
import de.mallongigi.podcast.progress.ProgressPool;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.concurrent.JavaFXUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

final class ChannelListRefreshHandler
extends AbstractProgressHandler<PodcastChannelModel> {
    private static final Logger LOG = Logger.getLogger(ChannelListRefreshHandler.class.getName());
    @Inject
    private ProgressPool progressPool;
    private boolean cancel = false;
    private final List<PodcastChannelModel> list;
    private final List<RefreshPodcastChannelModel> result = new ArrayList<RefreshPodcastChannelModel>();
    private final RefreshPodcastChannelClient util = new RefreshPodcastChannelClient();

    ChannelListRefreshHandler(List<PodcastChannelModel> list, ProgressModel<PodcastChannelModel> model) {
        super(model, ProgressAction.download);
        this.list = list;
        this.addFinishListener(f -> {
            if (this.isCancelled()) {
                return;
            }
            for (RefreshPodcastChannelModel m : this.result) {
                this.util.progressAddEpisodes(m);
                m.currentPodcastChannelModel().setErrorMessage(null);
            }
        });
    }

    @Override
    void handleCancel() {
        this.cancel = true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public ApplicationTask prepareProgress() throws Exception {
        return new ApplicationTask(){

            @Override
            public void start() {
                RefreshPodcastChannelClient util = new RefreshPodcastChannelClient();
                double totalProgress = ChannelListRefreshHandler.this.list.size();
                double currentProgress = 0.0;
                for (final PodcastChannelModel m : ChannelListRefreshHandler.this.list) {
                    if (ChannelListRefreshHandler.this.isCancelled() && util.isOld(m) && m.hasDownloads()) break;
                    JavaFXUtil.runLater(new Runnable(){

                        @Override
                        public void run() {
                            ChannelListRefreshHandler.this.getProgressModel().setTitle(m.getTitle());
                            ImageIconModel imageModel = ChannelListRefreshHandler.this.getProgressModel().getImage();
                            imageModel.setDeviceType(m.getImage().getDeviceType());
                            imageModel.setLocation(m.getImage().getLocation());
                            imageModel.refrehUI();
                        }
                    });
                    try {
                        LOG.info(String.format("Refresh %s", m.getPodcastFeedUrl()));
                        RefreshPodcastChannelModel refreshModel = util.refresh(m);
                        if (refreshModel != null) {
                            ChannelListRefreshHandler.this.result.add(refreshModel);
                            m.clearErrorMessage();
                        } else {
                            m.clearErrorMessage();
                        }
                    }
                    catch (Exception e) {
                        m.setErrorMessage(e.getClass().getName() + ":" + e.getMessage());
                        m.getChannelItemState().setState(UIState.DOWNLOAD_READY);
                    }
                    ChannelListRefreshHandler.this.setProgressState((currentProgress += 1.0) / totalProgress);
                }
            }
        };
    }
}

