/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.progress;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.file.FileUtil;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.progress.AbstractProgressHandler;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressModel;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.nio.file.Path;

public abstract class AbstractOpenDirectoryHandler
extends AbstractProgressHandler<PodcastEpisodeModel> {
    @Inject
    private OSPlatform osPlatform;
    private boolean cancel = false;

    AbstractOpenDirectoryHandler(ProgressModel<PodcastEpisodeModel> model, ProgressAction action) {
        super(model, action);
        this.addFinishListener(f -> this.handleReady());
        Container.inject(this);
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    void handleCancel() {
        this.cancel = true;
    }

    private void handleReady() {
        LanguageKeys errorMessage = this.model.getErrorMessage();
        Exception detail = this.model.getErrorMessageDetails();
        if (errorMessage != null) {
            new ErrorDialog().show(errorMessage, detail, this.model.getTitle());
        }
        PodcastEpisodeModel episode = (PodcastEpisodeModel)this.model.getModel();
        if (!this.isCancelled()) {
            try {
                Path file = FileUtil.getPodcastLocaleDownloadDirectory(episode.getChannel());
                this.osPlatform.open(file);
            }
            catch (Exception e) {
                new ErrorDialog().show(LanguageKeys.errorMessageOpenFolder, e, episode.getChannel());
            }
        }
        ((PodcastEpisodeModel)this.model.getModel()).getState().setInPool(false);
    }
}

