/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.ui.buttons;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.episode.model.PodcastEpisodeModelState;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeListModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.episode.ui.buttons.EpisodeBaseButton;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Inject;
import de.mallongigi.views.ApplicationViewNames;
import de.mallongigi.views.ApplicationViewsModel;
import java.nio.file.Path;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;

public final class PlayButton
extends EpisodeBaseButton {
    @Inject
    private PodcastEpisodeListModel podcastContentListModel;
    @Inject
    private ApplicationSettings appSettings;
    @Inject
    private ApplicationViewsModel viewModel;
    @Inject
    private OSPlatform osPlatform;

    public PlayButton(PodcastEpisodeModel model) {
        super(LanguageKeys.play, DefaultIcons.StartPlay, model.getId() + "_" + LanguageKeys.play.name());
        this.init(model);
    }

    private void init(final PodcastEpisodeModel model) {
        PodcastEpisodeModelState stateModel = model.getState();
        SimpleBooleanProperty isPresent = stateModel.presentProperty();
        this.visibleProperty().bind((ObservableValue)isPresent);
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                try {
                    model.getState().setPlayed(true);
                    model.setSelect(true);
                    PlayButton.this.podcastContentListModel.getCurrentChannelModel().refreshCurrentPodcastEpisodeSize();
                    if (PlayButton.this.appSettings.isUseInternalMediaPlayer()) {
                        PlayButton.this.viewModel.disableView(ApplicationViewNames.Mediaplayer, false);
                        PlayButton.this.viewModel.playEpisode(model);
                    } else {
                        Path file = model.getChannel().getPodcastFilenameConverter().convertEpisode(model);
                        PlayButton.this.osPlatform.open(file);
                    }
                }
                catch (Exception e) {
                    new ErrorDialog().show(LanguageKeys.errorMessageOpenFolder, (Throwable)e);
                }
            }
        });
    }
}

