/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.ui.buttons;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.file.FileUtil;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.episode.ui.buttons.EpisodeBaseButton;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.singleton.Inject;
import java.io.IOException;
import java.nio.file.Path;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;

public final class OpenFolderButton
extends EpisodeBaseButton {
    @Inject
    private OSPlatform osPlatform;

    public OpenFolderButton(PodcastEpisodeModel model) {
        super(LanguageKeys.openFolder, DefaultIcons.OpenFolder, model.getId() + "_" + LanguageKeys.openFolder.name());
        this.init(model);
    }

    private void init(final PodcastEpisodeModel model) {
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                try {
                    Path file = FileUtil.getPodcastLocaleDownloadDirectory(model.getChannel());
                    OpenFolderButton.this.osPlatform.open(file);
                    model.setSelect(true);
                }
                catch (IOException e) {
                    new ErrorDialog().show(LanguageKeys.errorMessageOpenFolder, (Throwable)e);
                }
            }
        });
    }
}

