/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.ui.buttons;

import de.mallongigi.podcast.channel.navigation.PodcastChannelNavigationModel;
import de.mallongigi.podcast.episode.model.PodcastEpisodeModelState;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.episode.ui.buttons.EpisodeBaseButton;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressPool;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.singleton.Inject;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;

public final class DownloadButton
extends EpisodeBaseButton {
    @Inject
    private ProgressPool progressPool;
    @Inject
    private PodcastChannelNavigationModel podcastChannelNavigationModel;

    public DownloadButton(PodcastEpisodeModel model) {
        super(LanguageKeys.downloads, DefaultIcons.DownloadEpisode, model.getId() + "_" + LanguageKeys.downloads.name());
        this.init(model);
    }

    private void init(final PodcastEpisodeModel model) {
        PodcastEpisodeModelState stateModel = model.getState();
        SimpleBooleanProperty isPresent = stateModel.presentProperty();
        SimpleBooleanProperty isInPool = stateModel.inPoolProperty();
        this.visibleProperty().bind((ObservableValue)isPresent.not().and((ObservableBooleanValue)isInPool.not()));
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                model.setCurrentDownload(true);
                DownloadButton.this.podcastChannelNavigationModel.getNewPodcastView().add(model);
                DownloadButton.this.progressPool.add(model, ProgressAction.download);
            }
        });
    }
}

