/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.navigation;

import de.mallongigi.file.FileUtil;
import de.mallongigi.file.PodcastFilenameConverter;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.episode.model.PodcastEpisodeDTO;
import de.mallongigi.singleton.Container;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;

public final class PodcastEpisodeModel
extends PodcastEpisodeDTO
implements Comparable<PodcastEpisodeModel> {
    private static final Logger LOG = Logger.getLogger(PodcastEpisodeModel.class.getName());
    private boolean currentDownload = false;
    private SimpleStringProperty errorMessage = new SimpleStringProperty();
    private SimpleBooleanProperty selected = new SimpleBooleanProperty(false);

    public boolean isCurrentDownload() {
        return this.currentDownload;
    }

    public void setCurrentDownload(boolean currentDownload) {
        this.currentDownload = currentDownload;
    }

    public boolean isOutOfDate() {
        Calendar calendar = Container.get(OSPlatform.class).getCalendar();
        calendar.set(2, calendar.get(2) - 1);
        return calendar.getTimeInMillis() > this.getDate().getTime();
    }

    public void setDuration(BigDecimal secondsValue) {
        Duration durMath = Duration.ofSeconds(secondsValue.longValueExact());
        this.setDuration(String.format("%02d:%02d:%02d", durMath.toHours(), durMath.toMinutesPart(), durMath.toSecondsPart()));
    }

    SimpleStringProperty durationProperty() {
        return this.duration;
    }

    public String getFilename() {
        try {
            Path path = this.getChannel().getPodcastFilenameConverter().convertEpisode(this);
            return path.getFileName().toString();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            return FileUtil.getFileNameFromUrl(this.getUrl(), "mp3");
        }
    }

    public String getDescriptionHTMLFree() {
        String value = this.getDescription();
        if (value == null) {
            return "";
        }
        value = value.replaceAll("<[^>]*>", "");
        return value;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage.set(errorMessage);
    }

    SimpleStringProperty errorMessageProperty() {
        return this.errorMessage;
    }

    BooleanProperty selectedProperty() {
        return this.selected;
    }

    public void setSelect(boolean state) {
        this.selected.set(state);
    }

    public boolean hasClearMP3File() {
        try {
            Path file = new PodcastFilenameConverter().convertToClearMP3Filename(this);
            return file.toFile().exists();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            return false;
        }
    }

    public boolean isMP3Format() {
        try {
            Path path = this.getChannel().getPodcastFilenameConverter().convertEpisode(this);
            String type = FileUtil.getFileFormat(path.toString());
            if (type == null) {
                return false;
            }
            type = type.toLowerCase();
            return type.equals("mp3");
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            return true;
        }
    }

    @Override
    public int compareTo(PodcastEpisodeModel model) {
        if (model == null) {
            return -1;
        }
        Date date = model.getDate();
        if (date == null) {
            return -1;
        }
        Date myDate = this.getDate();
        if (myDate == null) {
            return 1;
        }
        return myDate.compareTo(date);
    }
}

