/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.navigation;

import de.mallongigi.images.elements.UIImageFactory;
import de.mallongigi.images.model.ImageModelFactory;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.navigation.PodcastChannelNavigationModel;
import de.mallongigi.podcast.episode.model.PodcastEpisodeItemStyles;
import de.mallongigi.podcast.episode.model.PodcastEpisodeModelState;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeListModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.episode.ui.buttons.ClearMP3Button;
import de.mallongigi.podcast.episode.ui.buttons.ConvertButton;
import de.mallongigi.podcast.episode.ui.buttons.CopyButton;
import de.mallongigi.podcast.episode.ui.buttons.CopyToUSBButton;
import de.mallongigi.podcast.episode.ui.buttons.DeleteButton;
import de.mallongigi.podcast.episode.ui.buttons.DownloadButton;
import de.mallongigi.podcast.episode.ui.buttons.OpenFolderButton;
import de.mallongigi.podcast.episode.ui.buttons.PlayButton;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconColors;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.elements.UILabel;
import de.mallongigi.ui.elements.UIPopOver;
import de.mallongigi.ui.elements.UITooltip;
import de.mallongigi.ui.style.BasicCssClasses;
import de.mallongigi.ui.style.Styles;
import java.text.SimpleDateFormat;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public final class PodcastEpisodeItem {
    @Inject
    private Styles styles;
    @Inject
    private PodcastChannelNavigationModel podcastChannelNavigationModel;
    @Inject
    private PodcastEpisodeListModel podcastEpisodeListModel;
    @Inject
    private PodcastChannelContainer podcastChannelContainer;
    @Inject
    private IconFactory iconFactory;
    @Inject
    private UIImageFactory uiImageFactory;
    @Inject
    private ImageModelFactory imageModelFactory;
    private final PodcastEpisodeModel item;
    private final PodcastEpisodeItemUI root = new PodcastEpisodeItemUI(this);

    PodcastEpisodeItem(PodcastEpisodeModel item) {
        Container.inject(this);
        this.item = item;
        this.init();
        this.root.item = this;
    }

    public GridPane getUIComponent() {
        return this.root;
    }

    private void init() {
        this.root.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                PodcastEpisodeItem.this.item.setSelect(true);
            }
        });
        final PodcastEpisodeModelState state = this.item.getState();
        if (state.isPresent() || state.isNew()) {
            this.podcastChannelNavigationModel.getNewPodcastView().add(this.item);
        }
        this.item.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                PodcastEpisodeItem.this.refreshState(newValue);
            }
        });
        this.root.setPadding(new Insets(10.0));
        this.root.setHgap(15.0);
        this.root.setVgap(10.0);
        this.root.add(this.uiImageFactory.create(this.item, 100), 0, 0, 1, 4);
        final Node errorImage = this.iconFactory.create(DefaultIcons.RefreshError, 22, IconColors.Error);
        this.root.add(errorImage, 7, 1, 1, 1);
        if (this.item.errorMessageProperty().getValue() == null) {
            errorImage.setVisible(false);
        }
        this.item.errorMessageProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String oldValue, String newValue) {
                if (newValue != null && newValue.trim().length() > 0) {
                    errorImage.setVisible(true);
                    new UITooltip(PodcastEpisodeItem.this.item.errorMessageProperty().getValue()).install(errorImage);
                } else {
                    errorImage.setVisible(false);
                    new UITooltip("").install(errorImage);
                }
            }
        });
        final Label title = new Label(this.item.getTitle());
        title.setWrapText(true);
        this.setTitleStyle(state.isPlayed(), title);
        this.root.add((Node)title, 2, 1, 6, 1);
        state.playedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                PodcastEpisodeItem.this.setTitleStyle(state.isPlayed(), title);
            }
        });
        String subtitleText = this.item.getSubtitle();
        if (subtitleText == null || subtitleText.isBlank()) {
            subtitleText = this.item.getDescriptionHTMLFree();
        }
        HBox subtitleWrapper = new HBox();
        Label subtitle = new Label(subtitleText);
        subtitle.setPrefHeight(50.0);
        subtitle.setWrapText(true);
        Node descriptionOpenImage = this.iconFactory.create(DefaultIcons.open_in_new, 16);
        final UIPopOver descriptionBox = new UIPopOver(LanguageKeys.description, this.item.getDescriptionHTMLFree(), 400.0);
        descriptionOpenImage.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                descriptionBox.show(event);
            }
        });
        subtitleWrapper.getChildren().addAll((Object[])new Node[]{subtitle, descriptionOpenImage});
        subtitleWrapper.setAlignment(Pos.BOTTOM_LEFT);
        this.root.add((Node)subtitleWrapper, 2, 2, 7, 2);
        if (this.item.getDate() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
            Label date = new Label(sdf.format(this.item.getDate()));
            this.root.add((Node)date, 2, 0, 1, 1);
        }
        Label channelTitle = new Label(this.item.getChannel().getTitle());
        channelTitle.setCursor(Cursor.HAND);
        channelTitle.setOnMouseClicked((EventHandler)new EventHandler<Event>(){

            public void handle(Event arg0) {
                PodcastEpisodeItem.this.podcastChannelNavigationModel.setSelectedChannel(PodcastEpisodeItem.this.item.getChannel());
            }
        });
        this.root.add((Node)channelTitle, 3, 0, 5, 1);
        Label duration = new Label();
        duration.setMinWidth(100.0);
        duration.setAlignment(Pos.CENTER);
        duration.textProperty().bind((ObservableValue)this.item.durationProperty());
        this.root.add((Node)duration, 0, 4, 7, 1);
        UILabel filename = new UILabel(LanguageKeys.filename, this.item.getFilename());
        this.root.add((Node)filename, 2, 4, 7, 1);
        this.root.add((Node)new PlayButton(this.item), 2, 5, 1, 1);
        this.root.add((Node)new CopyButton(this.item), 3, 5, 1, 1);
        this.root.add((Node)new CopyToUSBButton(this.item), 4, 5, 1, 1);
        this.root.add((Node)new DeleteButton(this.item), 5, 5, 1, 1);
        this.root.add((Node)new OpenFolderButton(this.item), 6, 5, 1, 1);
        this.root.add((Node)new ConvertButton(this.item), 7, 5, 1, 1);
        this.root.add((Node)new ClearMP3Button(this.item), 7, 5, 1, 1);
        this.root.add((Node)new DownloadButton(this.item), 2, 5, 1, 1);
        this.item.getState().playedProperty().addListener((object, newValue, oldValue) -> this.refreshState(this.item.selectedProperty().getValue()));
        this.item.getState().presentProperty().addListener((object, newValue, oldValue) -> this.refreshState(this.item.selectedProperty().getValue()));
        this.refreshState(this.item.selectedProperty().getValue());
    }

    private void setTitleStyle(boolean isPlayed, Label title) {
        if (isPlayed) {
            this.styles.setStyle((Node)title, BasicCssClasses.titleListen);
        } else {
            this.styles.setStyle((Node)title, BasicCssClasses.title);
            this.styles.setStyle((Node)this.root, PodcastEpisodeItemStyles.NEW);
        }
    }

    private void refreshState(boolean isSelected) {
        this.item.getChannel().refreshCurrentPodcastEpisodeSize();
        PodcastEpisodeModelState state = this.item.getState();
        if (isSelected) {
            for (PodcastEpisodeModel pcm : this.podcastEpisodeListModel.getItems()) {
                if (pcm.equals(this.item) || !pcm.selectedProperty().get()) continue;
                pcm.setSelect(false);
            }
            this.styles.setStyle((Node)this.root, PodcastEpisodeItemStyles.SELECTED);
        } else if (state.isPresent()) {
            this.styles.setStyle((Node)this.root, PodcastEpisodeItemStyles.READY);
        } else if (this.item.isDownloaded()) {
            this.styles.setStyle((Node)this.root, PodcastEpisodeItemStyles.DOWNLOADED);
        } else {
            this.styles.setStyle((Node)this.root, PodcastEpisodeItemStyles.NEW);
        }
    }

    PodcastEpisodeModel getPodcastModel() {
        return this.item;
    }

    class PodcastEpisodeItemUI
    extends GridPane {
        private PodcastEpisodeItem item;

        private PodcastEpisodeItemUI(PodcastEpisodeItem this$0) {
        }

        public PodcastEpisodeItem getBusinessComponent() {
            return this.item;
        }
    }
}

