/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.channel.navigation;

import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeListChangeEvent;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeListListener;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import java.util.ArrayList;
import java.util.List;

public final class PodcastChannelViewModel
extends PodcastChannelModel {
    private PodcastEpisodeListListener podcastEpisodeListListener;

    public void removeItem(PodcastEpisodeModel item) {
        boolean result = this.items.remove((Object)item);
        if (result && this.podcastEpisodeListListener != null) {
            ArrayList<PodcastEpisodeModel> list = new ArrayList<PodcastEpisodeModel>();
            list.add(item);
            this.podcastEpisodeListListener.changed(new PodcastEpisodeListChangeEvent(this, list, 1));
        }
        this.refreshCurrentPodcastEpisodeSize();
    }

    @Override
    public boolean add(PodcastEpisodeModel item) {
        boolean result = super.add(item);
        if (result && this.podcastEpisodeListListener != null) {
            ArrayList<PodcastEpisodeModel> list = new ArrayList<PodcastEpisodeModel>();
            list.add(item);
            this.podcastEpisodeListListener.changed(new PodcastEpisodeListChangeEvent(this, list, 2));
        }
        return result;
    }

    @Override
    public boolean add(List<PodcastEpisodeModel> newItems) {
        boolean result = super.add(newItems);
        if (result && this.podcastEpisodeListListener != null) {
            this.podcastEpisodeListListener.changed(new PodcastEpisodeListChangeEvent(this, newItems, 2));
        }
        return result;
    }

    @Override
    public PodcastNavigationViewType getChannelType() {
        return PodcastNavigationViewType.PodcastView;
    }

    public void setPodcastEpisodeListListener(PodcastEpisodeListListener podcastEpisodeListListener) {
        this.podcastEpisodeListListener = podcastEpisodeListListener;
    }
}

