/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.channel.navigation;

import de.mallongigi.images.model.ImageModelFactory;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.channel.navigation.PodcastChannelViewModel;
import de.mallongigi.podcast.channel.ui.SelectChannelService;
import de.mallongigi.resource.images.DefaultImages;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Initialization;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

@Singleton
public final class PodcastChannelNavigationModel {
    @Inject
    private LanguageResource languageResource;
    @Inject
    private ImageModelFactory imageModelFactory;
    private final ObjectProperty<PodcastChannelModel> selectedChannel = new SimpleObjectProperty();
    private final PodcastChannelViewModel newPodcastView = new PodcastChannelViewModel();
    private final StringProperty podcastFilterString = new SimpleStringProperty();

    private PodcastChannelNavigationModel() {
    }

    @Initialization
    public void init() {
        this.selectedChannel.addListener((o, oldValue, newValue) -> new SelectChannelService(newValue.getChannelItemState()).start());
        this.newPodcastView.setImage(this.imageModelFactory.create(DefaultImages.New_Episodes));
        this.newPodcastView.setTitle(this.languageResource.messageForKey(LanguageKeys.newPodcastEpisodeView));
    }

    public PodcastChannelViewModel getNewPodcastView() {
        return this.newPodcastView;
    }

    public void setSelectedChannel(PodcastChannelModel model) {
        this.selectedChannel.set((Object)model);
    }

    public PodcastChannelModel getSelectedChannel() {
        return (PodcastChannelModel)this.selectedChannel.get();
    }

    ObjectProperty<PodcastChannelModel> selectedChannelProperty() {
        return this.selectedChannel;
    }

    StringProperty podcastFilterProperty() {
        return this.podcastFilterString;
    }

    public void clearFilter() {
        this.podcastFilterString.set((Object)"");
    }
}

