/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.channel.navigation;

import de.mallongigi.file.PodcastFilenameConverter;
import de.mallongigi.podcast.channel.model.PodcastChannelDTO;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.ChannelItemState;
import de.mallongigi.podcast.episode.model.PodcastEpisodeModelState;
import de.mallongigi.podcast.episode.navigation.EpisodeListComperator;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class PodcastChannelModel
extends PodcastChannelDTO {
    private final HashMap<String, String> alternativ = new HashMap();
    private final StringProperty currentEpisodeSize = new SimpleStringProperty(" 0 ");
    private final StringProperty errorProperty = new SimpleStringProperty("");
    private boolean automaticDownload = true;
    private long lastRefresh = 0L;
    private final BooleanProperty usbStickIsAvailable = new SimpleBooleanProperty(false);
    private final ChannelItemState channelItemState = new ChannelItemState();

    public PodcastNavigationViewType getChannelType() {
        return PodcastNavigationViewType.Podcast;
    }

    public void addAlternativ(String title, String url) {
        this.alternativ.put(title, url);
    }

    public HashMap<String, String> getAlternativ() {
        return this.alternativ;
    }

    public StringProperty getCurrentEpisodeProperty() {
        return this.currentEpisodeSize;
    }

    protected void setCurrentEpisodeSize(int size) {
        this.currentEpisodeSize.setValue(" " + size + " ");
    }

    public void setLastRefresh(long lastRefresh) {
        this.lastRefresh = lastRefresh;
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(PodcastEpisodeModel item) {
        try {
            if (item == null || this.items.contains((Object)item)) {
                boolean bl = false;
                return bl;
            }
            boolean result = this.items.add((Object)item);
            if (result) {
                new EpisodeListComperator().sort((List<PodcastEpisodeModel>)this.items);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.refreshCurrentPodcastEpisodeSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsavedAdd(PodcastEpisodeModel item) {
        if (item == null) {
            return false;
        }
        try {
            boolean result = this.items.add((Object)item);
            if (result) {
                new EpisodeListComperator().sort((List<PodcastEpisodeModel>)this.items);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.refreshCurrentPodcastEpisodeSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(List<PodcastEpisodeModel> newItems) {
        if (newItems.isEmpty()) {
            return false;
        }
        try {
            boolean result = this.items.addAll(newItems.stream().filter(e -> !this.items.contains(e)).toList());
            if (result) {
                new EpisodeListComperator().sort((List<PodcastEpisodeModel>)this.items);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.refreshCurrentPodcastEpisodeSize();
        }
    }

    public void refreshCurrentPodcastEpisodeSize() {
        int size = 0;
        for (PodcastEpisodeModel item : this.items) {
            PodcastEpisodeModelState state = item.getState();
            if (!state.isPresent() && !state.isNew() || state.isPlayed()) continue;
            ++size;
        }
        this.setCurrentEpisodeSize(size);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorProperty.set((Object)errorMessage);
    }

    public void clearErrorMessage() {
        this.errorProperty.set(null);
    }

    public Date getDateLastEpisode() {
        Date date = null;
        for (PodcastEpisodeModel em : this.getEpisodes()) {
            if (date == null) {
                date = em.getDate();
                continue;
            }
            if (date.getTime() >= em.getDate().getTime()) continue;
            date = em.getDate();
        }
        return date;
    }

    public PodcastFilenameConverter getPodcastFilenameConverter() {
        return new PodcastFilenameConverter();
    }

    public void setAutomaticDownload(boolean automaticDownload) {
        this.automaticDownload = automaticDownload;
    }

    public boolean isAutomaticDownload() {
        return this.automaticDownload;
    }

    public boolean hasErrorMessage() {
        return !this.errorProperty.isEmpty().get();
    }

    public BooleanProperty usbStickAvailableProperty() {
        return this.usbStickIsAvailable;
    }

    public void setUsbStickIsAvailable(boolean usbStickIsAvailable) {
        this.usbStickIsAvailable.setValue(Boolean.valueOf(usbStickIsAvailable));
    }

    public StringProperty usbPathProperty() {
        return this.usbPath;
    }

    public StringProperty errorProperty() {
        return this.errorProperty;
    }

    public ChannelItemState getChannelItemState() {
        return this.channelItemState;
    }

    public boolean hasDownloads() {
        for (PodcastEpisodeModel e : this.getEpisodes()) {
            if (!e.isCurrentDownload()) continue;
            return true;
        }
        return false;
    }
}

