/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.channel.model;

import de.mallongigi.images.model.ImageModel;
import de.mallongigi.podcast.channel.model.PodcastChannelFeedType;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.model.Model;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public abstract class PodcastChannelDTO
implements Model {
    private long id;
    private String title = "";
    private String homepage = "";
    private String description = "";
    private String remoteImageUrl = "";
    private String cachHash = "";
    private String localeDirectory;
    protected final ObservableList<PodcastEpisodeModel> items = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableList(new ArrayList()));
    private String podcastFeedUrl;
    private ImageModel image;
    protected final StringProperty usbPath = new SimpleStringProperty();
    private PodcastChannelFeedType podcastChannelFeedType;
    private boolean hasEpisodeListListener = false;

    protected PodcastChannelDTO() {
    }

    public void setPodcastFeedUrl(String podcastFeedUrl) {
        this.podcastFeedUrl = podcastFeedUrl;
    }

    public String getPodcastFeedUrl() {
        return this.podcastFeedUrl;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getImageURL() {
        return this.remoteImageUrl;
    }

    public void setImageURL(String url) {
        this.remoteImageUrl = url;
    }

    public String getLocaleDirectory() {
        return this.localeDirectory;
    }

    public void setLocaleDirectory(String localeDirectory) {
        this.localeDirectory = localeDirectory;
    }

    public List<PodcastEpisodeModel> getEpisodes() {
        return this.items.stream().collect(Collectors.toList());
    }

    public ImageModel getImage() {
        return this.image;
    }

    public void setImage(ImageModel image) {
        this.image = image;
    }

    public void setCachHash(String cachHash) {
        this.cachHash = cachHash;
    }

    public String getCachHash() {
        return this.cachHash;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setFeedType(PodcastChannelFeedType type) {
        this.podcastChannelFeedType = type;
    }

    public PodcastChannelFeedType getFeedType() {
        return this.podcastChannelFeedType;
    }

    public void setUsbPath(String usbPath) {
        this.usbPath.set((Object)usbPath);
    }

    public String getUsbPath() {
        return (String)this.usbPath.get();
    }

    public StringProperty getUsbPathProberty() {
        return this.usbPath;
    }

    public void addItemListener(ListChangeListener<PodcastEpisodeModel> listener) {
        if (this.hasEpisodeListListener) {
            return;
        }
        this.hasEpisodeListListener = true;
        this.items.addListener(listener);
    }
}

