/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.platform;

import com.pixelduke.window.ThemeWindowManager;
import com.pixelduke.window.ThemeWindowManagerFactory;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import de.mallongigi.platform.OSPlatform;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Dialog;
import javafx.stage.Window;

public class WindowsPlatform
implements OSPlatform {
    private static final Logger LOG = Logger.getLogger(WindowsPlatform.class.getName());
    private Kernel32 INSTANCE;
    private ThemeWindowManager themeWindowManager;

    @Override
    public void disableScreenSaver() {
        this.INSTANCE.SetThreadExecutionState(-2147483646);
    }

    @Override
    public void resetScreenSaverState() {
        this.INSTANCE.SetThreadExecutionState(Integer.MIN_VALUE);
    }

    @Override
    public void init() {
        try {
            this.themeWindowManager = ThemeWindowManagerFactory.create();
            this.INSTANCE = Native.load("kernel32", Kernel32.class);
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
        }
    }

    @Override
    public long getSystemTime() {
        return System.currentTimeMillis();
    }

    @Override
    public Date getSystemDate() {
        return new Date();
    }

    @Override
    public Calendar getCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.getSystemTime());
        return c;
    }

    @Override
    public void setDarkMode(Window stage) {
        if (this.themeWindowManager != null) {
            this.themeWindowManager.setDarkModeForWindowFrame(stage, true);
        }
    }

    @Override
    public void setDarkMode(final Dialog<?> dialog) {
        if (this.themeWindowManager != null) {
            final Window window = dialog.getDialogPane().getScene().getWindow();
            dialog.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (dialog.isShowing()) {
                        WindowsPlatform.this.setDarkMode(window);
                    }
                }
            });
        }
    }

    @Override
    public void open(Path path) throws IOException {
        Desktop.getDesktop().open(path.toFile());
    }

    @Override
    public String getFFMPEGDefaulPath() {
        return "ffmpeg" + File.separator + "bin" + File.separator + "ffmpeg.exe";
    }
}

