/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.opml;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import de.mallongigi.ui.style.Styles;
import java.nio.file.Path;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.control.Alert;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public final class OPMLExport
extends Service<Void> {
    @Inject
    private PodcastChannelContainer podcastChannelContainer;
    @Inject
    private Styles styles;
    @Inject
    private IconFactory iconFactory;
    @Inject
    private LanguageResource languageResource;
    private Path file;

    private OPMLExport() {
    }

    public OPMLExport setFile(Path file) {
        this.file = file;
        return this;
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document result = documentBuilder.newDocument();
        Element root = result.createElement("opml");
        root.setAttribute("version", "1.0");
        result.appendChild(root);
        Element head = result.createElement("head");
        Element title = result.createElement("title");
        title.setTextContent("Mallongigi - Podcast RSS and ARD Auidothek Subscriptions");
        head.appendChild(title);
        root.appendChild(head);
        for (PodcastChannelModel channel : this.podcastChannelContainer.getPodcastChannels(PodcastNavigationViewType.Podcast)) {
            Element outline = result.createElement("outline");
            switch (channel.getFeedType()) {
                case Audiothek: {
                    outline.setAttribute("type", "json");
                    outline.setAttribute("jsonUrl", channel.getPodcastFeedUrl());
                    break;
                }
                default: {
                    outline.setAttribute("type", "rss");
                    outline.setAttribute("xmlUrl", channel.getPodcastFeedUrl());
                }
            }
            outline.setAttribute("text", channel.getTitle());
            outline.setAttribute("title", channel.getTitle());
            outline.setAttribute("htmlUrl", channel.getHomepage());
            root.appendChild(outline);
        }
        return result;
    }

    protected Task<Void> createTask() {
        return new Task<Void>(){

            protected Void call() throws Exception {
                Document doc = OPMLExport.this.createDocument();
                DOMSource domSource = new DOMSource(doc);
                StreamResult streamResult = new StreamResult(OPMLExport.this.file.toFile());
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer serializer = tf.newTransformer();
                serializer.setOutputProperty("encoding", "UTF-8");
                serializer.setOutputProperty("indent", "yes");
                serializer.transform(domSource, streamResult);
                return null;
            }
        };
    }

    protected void succeeded() {
        super.succeeded();
        Alert dialog = new Alert(Alert.AlertType.INFORMATION);
        this.styles.setStyle(dialog.getDialogPane());
        this.styles.setWindowIcon(dialog.getDialogPane(), DefaultIcons.Window);
        dialog.setTitle(this.languageResource.messageForKey(LanguageKeys.succesDialog));
        dialog.setHeaderText(this.languageResource.messageForKey(LanguageKeys.exportFinishMessage));
        dialog.setGraphic(this.iconFactory.create(DefaultIcons.Export, 48));
        dialog.showAndWait();
    }

    protected void failed() {
        super.failed();
        new ErrorDialog().show(LanguageKeys.errorMessageExportOPML, this.getException());
    }
}

