/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.opml;

import de.mallongigi.dialog.InitialLoadFeedDataDialog;
import de.mallongigi.http.feed.FeedURLConnector;
import de.mallongigi.http.feed.PodcastFeedConfigFactory;
import de.mallongigi.http.feed.PodcastFeedConnectionConfig;
import de.mallongigi.opml.OPMLLoaderTask;
import de.mallongigi.opml.Outline;
import de.mallongigi.podcast.channel.model.NewPodcastChannelHelper;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;
import javafx.concurrent.Service;
import javafx.concurrent.Task;

@Singleton
public final class ImportOPMLService
extends Service<List<Outline>> {
    private static final Logger LOG = Logger.getLogger(ImportOPMLService.class.getName());
    @Inject
    private ApplicationSettings settings;
    private Path opmlFile;
    private InitialLoadFeedDataDialog importDialog;
    private final NewPodcastChannelHelper executionUtil = new NewPodcastChannelHelper();

    private ImportOPMLService() {
    }

    public ImportOPMLService setFile(Path opmlFile) {
        this.opmlFile = opmlFile;
        return this;
    }

    protected Task<List<Outline>> createTask() {
        this.importDialog = new InitialLoadFeedDataDialog(DefaultIcons.Import);
        OPMLLoaderTask loader = new OPMLLoaderTask();
        loader.setFile(this.opmlFile);
        this.importDialog.show();
        return loader;
    }

    protected void succeeded() {
        for (Outline outline : (List)this.getValue()) {
            try {
                String result;
                PodcastChannelModel m = this.getPodcastChannelModel(outline);
                if (!m.getAlternativ().isEmpty() && !(result = this.importDialog.selectAlternative(m)).equals(m.getPodcastFeedUrl())) {
                    outline.setUrl(result);
                    m = this.getPodcastChannelModel(outline);
                }
                this.executionUtil.addPodcastFeed(m, false);
                this.importDialog.addSuccess();
            }
            catch (Exception e) {
                this.executionUtil.addErrorMessage(e, outline.getUrl(), this.importDialog);
                this.importDialog.addFail();
            }
        }
        this.importDialog.showFinishMessage();
        this.importDialog.enableButton();
    }

    private PodcastChannelModel getPodcastChannelModel(Outline outline) throws Exception {
        LOG.info("Import " + outline.getUrl());
        PodcastChannelModel dummy = new PodcastChannelModel();
        dummy.setPodcastFeedUrl(outline.getUrl());
        dummy.setFeedType(outline.getFeedType());
        PodcastFeedConnectionConfig config = new PodcastFeedConfigFactory().getConfig(dummy);
        PodcastChannelModel m = config.getPodcastChannelParser(false).parse(new FeedURLConnector(dummy, config));
        m.setId(this.settings.nextPodcastChannelIdCount());
        return m;
    }
}

