/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer.transcription;

import de.mallongigi.mediaplayer.transcription.SpeakerColor;
import de.mallongigi.mediaplayer.transcription.TranscriptionPart;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.time.PodloveTimeConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TranscriptionVTTParser {
    private static final Logger LOG = Logger.getLogger(TranscriptionVTTParser.class.getName());
    @Inject
    private PodloveTimeConverter timeConverter;

    TranscriptionVTTParser() {
        Container.inject(this);
    }

    List<TranscriptionPart> parse(String vttString) {
        System.out.println(vttString);
        ArrayList<TranscriptionPart> result = new ArrayList<TranscriptionPart>();
        String[] vttParts = vttString.split("\n\n");
        SpeakerColor speakerColors = new SpeakerColor();
        for (String p : vttParts) {
            try {
                if (p.equals("WEBVTT")) continue;
                String start = p.substring(0, 12);
                String end = p.substring(17, 29);
                p = p.substring(p.indexOf("\n"), p.length());
                String speaker = p.substring(1, p.indexOf(":"));
                String text = p.substring(p.indexOf(":"), p.length()).trim();
                TranscriptionPart tp = new TranscriptionPart();
                tp.setEnd(this.timeConverter.convert(end)).setSpeaker(speaker).setSpeakerColor(speakerColors.getColor(speaker)).setStart(this.timeConverter.convert(start)).setText(text);
                result.add(tp);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
        return result;
    }
}

