/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer.transcription;

import de.mallongigi.mediaplayer.transcription.SpeakerColor;
import de.mallongigi.mediaplayer.transcription.TranscriptionPart;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.time.PodloveTimeConverter;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public final class TranscriptionJSONParser {
    @Inject
    private PodloveTimeConverter timeConverter;

    TranscriptionJSONParser() {
        Container.inject(this);
    }

    List<TranscriptionPart> parse(String jsonString) {
        ArrayList<TranscriptionPart> result = new ArrayList<TranscriptionPart>();
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonString));
        JsonArray parts = jsonReader.readArray();
        final SpeakerColor speakerColors = new SpeakerColor();
        parts.forEach(o -> {
            final JsonObject part = o.asJsonObject();
            final TranscriptionPart p = new TranscriptionPart();
            part.forEach((BiConsumer)new BiConsumer<String, JsonValue>(){

                @Override
                public void accept(String key, JsonValue v) {
                    switch (key) {
                        case "text": {
                            p.setText(part.getString(key));
                            break;
                        }
                        case "voice": {
                            p.setSpeaker(part.getString(key));
                            break;
                        }
                        case "speaker": 
                        case "speaker_id": {
                            if (p.getSpeaker() == null) {
                                p.setSpeaker(part.getString(key));
                            }
                            p.setSpeakerColor(speakerColors.getColor(p.getSpeaker()));
                            break;
                        }
                        case "start_ms": {
                            p.setStart(part.getJsonNumber(key).longValue());
                            break;
                        }
                        case "end_ms": {
                            p.setEnd(part.getJsonNumber(key).longValue());
                            break;
                        }
                        case "start": {
                            if (p.getStart() != null) break;
                            p.setStart(TranscriptionJSONParser.this.timeConverter.convert(v.toString()));
                            break;
                        }
                        case "end": {
                            if (p.getEnd() != null) break;
                            p.setEnd(TranscriptionJSONParser.this.timeConverter.convert(v.toString()));
                        }
                    }
                }
            });
            if (p.getSpeaker() == null) {
                p.setSpeaker("Unknown Speaker");
                p.setSpeakerColor(p.getSpeakerColor());
            }
            result.add(p);
        });
        return result;
    }

    List<TranscriptionPart> parse(Path file) throws IOException {
        String jsonString = Files.readString(file, StandardCharsets.UTF_8);
        ArrayList<TranscriptionPart> result = new ArrayList<TranscriptionPart>();
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonString));
        JsonArray parts = jsonReader.readArray();
        parts.forEach(o -> {
            final JsonObject part = o.asJsonObject();
            final TranscriptionPart p = new TranscriptionPart();
            part.forEach((BiConsumer)new BiConsumer<String, JsonValue>(){

                @Override
                public void accept(String key, JsonValue v) {
                    switch (key) {
                        case "text": {
                            p.setText(part.getString(key));
                            break;
                        }
                        case "speaker": {
                            p.setSpeaker(part.getString(key));
                            break;
                        }
                        case "speakerColor": {
                            p.setSpeakerColor(part.getString(key));
                            break;
                        }
                        case "start": {
                            p.setStart(part.getJsonNumber(key).longValue());
                            break;
                        }
                        case "end": {
                            p.setEnd(part.getJsonNumber(key).longValue());
                        }
                    }
                }
            });
            result.add(p);
        });
        return result;
    }
}

