/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer.audio;

import de.mallongigi.images.PixelImageLoader;
import de.mallongigi.images.elements.UIImageFactory;
import de.mallongigi.images.model.ImageModel;
import de.mallongigi.images.model.ImageModelFactory;
import de.mallongigi.mediaplayer.audio.AudioMediaPlayerContentPane;
import de.mallongigi.podcast.episode.model.Chapter;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.time.DateTimeConverter;
import de.mallongigi.ui.concurrent.JavaFXUtil;
import de.mallongigi.ui.style.BasicCssClasses;
import de.mallongigi.ui.style.Styles;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;

public final class ChapterNavigation {
    private static final Logger LOG = Logger.getLogger(ChapterNavigation.class.getName());
    @Inject
    private DateTimeConverter dateTimeConverter;
    @Inject
    private Styles styles;
    @Inject
    private ImageModelFactory imageModelFactory;
    @Inject
    private UIImageFactory uiImageFactory;
    private final ExecutorService imageDownloadPool = Executors.newFixedThreadPool(1);
    private final VBox navigation = new VBox(5.0);
    private final ScrollPane root = new ScrollPane((Node)this.navigation);
    private SortedMap<Chapter, HBox> chaptersMap;
    private Chapter currentChapter;
    private AudioMediaPlayerContentPane view;
    private PodcastEpisodeModel pem;

    ChapterNavigation(AudioMediaPlayerContentPane view) {
        Container.inject(this);
        this.view = view;
        this.chaptersMap = new TreeMap<Chapter, HBox>(new Comparator<Chapter>(this){

            @Override
            public int compare(Chapter o1, Chapter o2) {
                return o1.getStartTime().compareTo(o2.getStartTime());
            }
        });
    }

    ScrollPane getComponent() {
        return this.root;
    }

    void setPodcastEpisode(final PodcastEpisodeModel pem, final MediaPlayer player) {
        this.pem = pem;
        this.navigation.getChildren().clear();
        this.chaptersMap.clear();
        Image defaultImage = new PixelImageLoader().create(pem.getImage(), 40).image();
        this.currentChapter = null;
        Chapter[] chapters = pem.getChapters();
        if (chapters.length > 0) {
            this.currentChapter = chapters[0];
            for (final Chapter c : chapters) {
                final HBox box = new HBox();
                box.setUserData((Object)c);
                box.getChildren().addAll((Object[])new Node[]{new ImageView(defaultImage), new Label(" " + this.dateTimeConverter.convert(c.getStartTime(), DateTimeConverter.Time.Milliseconds) + " - " + c.getTitle())});
                box.setAlignment(Pos.CENTER_LEFT);
                this.styles.setStyle((Node)box, BasicCssClasses.defaultBackground);
                box.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        player.seek(new Duration((double)(c.getStartTime() + 1000L)));
                    }
                });
                if (c.getImageURL() != null) {
                    this.imageDownloadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                new PixelImageLoader().download(c, pem);
                                JavaFXUtil.runLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            ImageModel image = ChapterNavigation.this.imageModelFactory.create(c, pem);
                                            box.getChildren().removeFirst();
                                            box.getChildren().addFirst((Object)ChapterNavigation.this.uiImageFactory.create(image, 40));
                                        }
                                        catch (Exception e) {
                                            LOG.log(Level.INFO, e.getMessage(), e);
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                LOG.log(Level.INFO, e.getLocalizedMessage(), e);
                            }
                        }
                    });
                }
                this.chaptersMap.put(c, box);
                this.navigation.getChildren().add((Object)box);
            }
            if (this.currentChapter != null) {
                this.styles.setStyle((Node)this.chaptersMap.get(this.currentChapter), BasicCssClasses.selectedBackground);
            }
        }
    }

    void setVisible(boolean state) {
        this.root.setVisible(state);
    }

    public void setCurrentPlayTime(long time) {
        if (this.view == null) {
            return;
        }
        Object current = null;
        for (Chapter c : this.chaptersMap.keySet()) {
            if (c.getStartTime() >= time) continue;
            current = c;
        }
        if (current == null || current.equals(this.currentChapter)) {
            return;
        }
        HBox box = (HBox)this.chaptersMap.get(this.currentChapter);
        if (box != null) {
            this.styles.setStyle((Node)box, BasicCssClasses.defaultBackground);
        }
        this.currentChapter = current;
        box = (HBox)this.chaptersMap.get(this.currentChapter);
        if (box != null) {
            this.styles.setStyle((Node)box, BasicCssClasses.selectedBackground);
        }
        this.view.setChapter((Chapter)current, this.pem);
    }
}

