/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.mediaplayer.audio;

import de.mallongigi.errorhandling.ErrorContainer;
import de.mallongigi.mediaplayer.MediaplayerKeyHandler;
import de.mallongigi.mediaplayer.PlaySpeedSelection;
import de.mallongigi.mediaplayer.VolumeSlider;
import de.mallongigi.mediaplayer.audio.AudioMediaPlayerContentPane;
import de.mallongigi.mediaplayer.audio.ChapterNavigation;
import de.mallongigi.mediaplayer.timebar.TimeBar;
import de.mallongigi.mediaplayer.transcription.EpisodeTranscription;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.elements.UIButton;
import de.mallongigi.ui.elements.UIToggleButton;
import de.mallongigi.views.ApplicationViewNames;
import de.mallongigi.views.ApplicationViewsModel;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.stage.Stage;
import javafx.util.Duration;

public final class AudioMediaPlayer {
    private static final Logger LOG = Logger.getLogger(AudioMediaPlayer.class.getName());
    @Inject(safety=false)
    private Stage primaryStage;
    @Inject
    private ErrorContainer errorContainer;
    @Inject
    private IconFactory iconFactory;
    @Inject
    private ApplicationViewsModel viewModel;
    @Inject
    private LanguageResource languageResource;
    private final BorderPane root = new BorderPane();
    private AudioMediaPlayerContentPane contentPane;
    private ChapterNavigation chapters;
    private Path mediaFile;
    private PodcastEpisodeModel podcastEpisodeModel;
    private double startDuration;
    private VolumeSlider volumeSlider;
    private TimeBar timeBar;
    private MediaView mediaView;
    private final UIButton playButton = new UIButton(LanguageKeys.pause, DefaultIcons.PausePlay);
    private final UIButton stopButton = new UIButton(LanguageKeys.stop, DefaultIcons.StopPlay);
    private MediaplayerKeyHandler keyHandler;
    private UIToggleButton subtitlesButton;
    private UIToggleButton chapterButton;

    public AudioMediaPlayer() {
        Container.inject(this);
    }

    public void setPodcastEpisode(PodcastEpisodeModel model) throws Exception {
        this.podcastEpisodeModel = model;
        this.mediaFile = this.podcastEpisodeModel.getChannel().getPodcastFilenameConverter().convertEpisode(this.podcastEpisodeModel);
        this.startDuration = this.podcastEpisodeModel.getPlayerDuration();
    }

    public BorderPane getRoot() {
        return this.root;
    }

    public boolean play() {
        try {
            Media pick = new Media(this.mediaFile.toUri().toString());
            MediaPlayer player = new MediaPlayer(pick);
            player.setStartTime(new Duration(this.startDuration));
            if (this.mediaView == null) {
                this.init(player);
            } else {
                if (this.mediaView.getMediaPlayer().getStatus().equals((Object)MediaPlayer.Status.READY)) {
                    this.stopPlayer();
                }
                this.mediaView.setMediaPlayer(player);
            }
            this.restart();
            player.play();
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, this.errorContainer.add(LanguageKeys.errorMessageDownloadFile, "URL Play " + this.podcastEpisodeModel.getTitle()), e);
            return false;
        }
    }

    private void init(MediaPlayer player) throws Exception {
        this.playButton.setMinWidth(100.0);
        this.mediaView = new MediaView(player);
        this.volumeSlider = new VolumeSlider(this.mediaView);
        this.timeBar = new TimeBar(this.mediaView);
        final VBox navigationWrapper = new VBox();
        navigationWrapper.setUserData((Object)false);
        navigationWrapper.setStyle("-fx-background-color: rgba(0, 0, 0, .7)");
        HBox navigation = new HBox();
        navigation.setSpacing(30.0);
        navigation.setAlignment(Pos.TOP_CENTER);
        this.root.getParent().setStyle("-fx-background-color: rgba(0, 0, 0, 1)");
        this.subtitlesButton = new UIToggleButton(LanguageKeys.subtitles, DefaultIcons.subtitles);
        this.subtitlesButton.setSelected(false);
        this.contentPane = new AudioMediaPlayerContentPane(this.subtitlesButton.selectedProperty());
        final UIToggleButton shownotesButton = new UIToggleButton(LanguageKeys.shownotes, DefaultIcons.shownotes);
        shownotesButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    if (shownotesButton.isSelected()) {
                        AudioMediaPlayer.this.contentPane.setShownotes(AudioMediaPlayer.this.podcastEpisodeModel.getShownotes());
                    } else {
                        AudioMediaPlayer.this.contentPane.showCurrentChapterImage();
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, e.getMessage(), e);
                }
            }
        });
        this.chapters = new ChapterNavigation(this.contentPane);
        this.root.setRight((Node)this.chapters.getComponent());
        this.chapterButton = new UIToggleButton(LanguageKeys.chapterList, DefaultIcons.chapterList);
        this.chapterButton.setSelected(true);
        this.chapterButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AudioMediaPlayer.this.chapters.setVisible(AudioMediaPlayer.this.chapterButton.isSelected());
            }
        });
        navigation.getChildren().addAll((Object[])new Node[]{this.playButton, this.stopButton, this.volumeSlider.create(), new PlaySpeedSelection(this.mediaView).create(), shownotesButton, this.chapterButton, this.subtitlesButton});
        this.root.setCenter((Node)this.contentPane.getComponent());
        navigationWrapper.getChildren().addAll((Object[])new Node[]{this.timeBar.create(), navigation});
        navigationWrapper.layoutXProperty().set(10.0);
        this.root.setBottom((Node)navigationWrapper);
        DoubleProperty mvw = this.mediaView.fitWidthProperty();
        DoubleProperty mvh = this.mediaView.fitHeightProperty();
        mvw.bind((ObservableValue)Bindings.selectDouble((ObservableValue)this.mediaView.sceneProperty(), (String[])new String[]{"width"}));
        mvh.bind((ObservableValue)Bindings.selectDouble((ObservableValue)this.mediaView.sceneProperty(), (String[])new String[]{"height"}));
        this.root.getScene().widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                navigationWrapper.setPrefWidth(arg2.doubleValue() - 20.0);
            }
        });
        this.mediaView.getMediaPlayer().setOnPaused(new Runnable(){

            @Override
            public void run() {
                AudioMediaPlayer.this.playButton.setText(AudioMediaPlayer.this.languageResource.messageForKey(LanguageKeys.play));
                AudioMediaPlayer.this.playButton.setGraphic(AudioMediaPlayer.this.iconFactory.create(DefaultIcons.StartPlay));
            }
        });
        this.mediaView.getMediaPlayer().setOnPlaying(new Runnable(){

            @Override
            public void run() {
                AudioMediaPlayer.this.playButton.setText(AudioMediaPlayer.this.languageResource.messageForKey(LanguageKeys.pause));
                AudioMediaPlayer.this.playButton.setGraphic(AudioMediaPlayer.this.iconFactory.create(DefaultIcons.PausePlay));
            }
        });
        this.keyHandler = new MediaplayerKeyHandler(this.mediaView.getMediaPlayer(), this.volumeSlider, () -> this.stopPlayer());
    }

    private void restart() {
        EpisodeTranscription episodeTranscription = new EpisodeTranscription(this.contentPane.getComponent());
        episodeTranscription.setEpisode(this.podcastEpisodeModel);
        this.subtitlesButton.setVisible(this.podcastEpisodeModel.hasTranscriptions());
        this.chapterButton.setSelected(this.podcastEpisodeModel.hasChapters());
        this.chapterButton.setVisible(this.podcastEpisodeModel.hasChapters());
        this.primaryStage.setTitle(this.podcastEpisodeModel.getTitle());
        this.root.setUserData((Object)false);
        this.chapters.setPodcastEpisode(this.podcastEpisodeModel, this.mediaView.getMediaPlayer());
        if (this.podcastEpisodeModel.hasChapters()) {
            this.contentPane.setChapter(this.podcastEpisodeModel.getChapters()[0], this.podcastEpisodeModel);
            this.chapters.setVisible(true);
        } else {
            this.contentPane.setChapter(null, this.podcastEpisodeModel);
        }
        this.keyHandler.setPlayer(this.mediaView.getMediaPlayer());
        this.playButton.setOnAction(e -> {
            MediaPlayer player = this.mediaView.getMediaPlayer();
            if (player.getStatus().equals((Object)MediaPlayer.Status.PLAYING)) {
                player.pause();
            } else {
                player.play();
            }
        });
        this.stopButton.setOnAction(e -> this.stopPlayer());
        this.mediaView.getMediaPlayer().setOnEndOfMedia(() -> {
            this.root.setCursor(Cursor.DEFAULT);
            if (this.primaryStage.isFullScreen()) {
                this.primaryStage.setFullScreen(false);
            }
            this.podcastEpisodeModel.setPlayerDuration(0.0);
        });
        this.volumeSlider.reset();
        this.timeBar.restart(this.keyHandler, () -> this.stopPlayer(), this.chapters, episodeTranscription);
    }

    private void stopPlayer() {
        this.keyHandler.removePlayer();
        this.primaryStage.setTitle("Mallongigi");
        if (this.mediaView.getMediaPlayer().getStatus() != MediaPlayer.Status.PLAYING && this.mediaView.getMediaPlayer().getStatus() != MediaPlayer.Status.PAUSED) {
            return;
        }
        if (this.mediaView.getMediaPlayer().getCurrentTime().toMillis() != this.mediaView.getMediaPlayer().getTotalDuration().toMillis()) {
            this.podcastEpisodeModel.setPlayerDuration(this.mediaView.getMediaPlayer().getCurrentTime().toMillis());
        }
        this.mediaView.getMediaPlayer().stop();
        this.viewModel.setView(ApplicationViewNames.Podcasts);
        this.viewModel.clearPlayer();
        this.viewModel.disableView(ApplicationViewNames.Mediaplayer, true);
        this.mediaView.getMediaPlayer().dispose();
        this.timeBar.stop(this.keyHandler);
        this.volumeSlider.stop();
    }

    public void stop() {
        if (this.mediaView == null) {
            return;
        }
        MediaPlayer player = this.mediaView.getMediaPlayer();
        if (player.getStatus() == MediaPlayer.Status.PLAYING) {
            this.mediaView.getMediaPlayer().stop();
        }
    }

    public boolean isPlaying(PodcastEpisodeModel item) {
        return this.podcastEpisodeModel != null && this.podcastEpisodeModel.equals(item);
    }
}

